/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.impersonation;

import io.confluent.rest.exceptions.RestServerErrorException;
import io.confluent.rest.impersonation.Errors;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.security.UserGroupInformation;

public class ImpersonatedExecutor {
    public <T> T runAs(String username, PrivilegedAction<T> action) {
        UserGroupInformation ugi = this.getImpersonatedUser(username);
        try {
            return (T)ugi.doAs(action);
        }
        catch (RestServerErrorException e) {
            throw Errors.serverLoginException("It is not possible to do this operation", (Throwable)((Object)e));
        }
    }

    public <T> T runThrowingAs(String username, PrivilegedExceptionAction<T> action) throws Exception {
        UserGroupInformation ugi = this.getImpersonatedUser(username);
        try {
            return (T)ugi.doAs(action);
        }
        catch (RestServerErrorException e) {
            throw Errors.serverLoginException("It is not possible to do this operation", (Throwable)((Object)e));
        }
        catch (UndeclaredThrowableException e) {
            throw e.getCause() instanceof Exception ? (Exception)e.getCause() : e;
        }
    }

    public UserGroupInformation getImpersonatedUser(String username) {
        try {
            UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
            if (currentUser.getUserName().equals(username)) {
                return currentUser;
            }
            return UserGroupInformation.createProxyUser((String)username, (UserGroupInformation)UserGroupInformation.getLoginUser());
        }
        catch (IOException e) {
            throw Errors.serverLoginException(e);
        }
    }
}

