/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.metastore.StructuredDataSource;
import io.confluent.ksql.parser.AstBuilder;
import io.confluent.ksql.parser.SqlBaseBaseVisitor;
import io.confluent.ksql.parser.SqlBaseParser;
import io.confluent.ksql.parser.tree.AliasedRelation;
import io.confluent.ksql.parser.tree.Node;
import io.confluent.ksql.parser.tree.NodeLocation;
import io.confluent.ksql.parser.tree.QualifiedName;
import io.confluent.ksql.parser.tree.Relation;
import io.confluent.ksql.parser.tree.Table;
import io.confluent.ksql.util.KsqlException;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;

public class DataSourceExtractor
extends SqlBaseBaseVisitor<Node> {
    private final MetaStore metaStore;
    private Schema joinLeftSchema;
    private Schema joinRightSchema;
    private String fromAlias;
    private String leftAlias;
    private String rightAlias;
    private Set<String> commonFieldNames = new HashSet<String>();
    private Set<String> leftFieldNames = new HashSet<String>();
    private Set<String> rightFieldNames = new HashSet<String>();
    private boolean isJoin = false;

    public DataSourceExtractor(MetaStore metaStore) {
        this.metaStore = metaStore;
    }

    @Override
    public Node visitQuerySpecification(SqlBaseParser.QuerySpecificationContext ctx) {
        this.visit((ParseTree)ctx.from);
        return (Node)this.visitChildren((RuleNode)ctx);
    }

    @Override
    public Node visitTableName(SqlBaseParser.TableNameContext context) {
        return new Table(DataSourceExtractor.getLocation(context), DataSourceExtractor.getQualifiedName(context.qualifiedName()));
    }

    @Override
    public Node visitAliasedRelation(SqlBaseParser.AliasedRelationContext context) {
        Table table = (Table)this.visit((ParseTree)context.relationPrimary());
        String alias = null;
        if (context.children.size() == 1) {
            alias = table.getName().getSuffix().toUpperCase();
        } else if (context.children.size() == 2) {
            alias = ((ParseTree)context.children.get(1)).getText().toUpperCase();
        }
        if (!this.isJoin) {
            this.fromAlias = alias;
            StructuredDataSource fromDataSource = this.metaStore.getSource(table.getName().getSuffix());
            if (fromDataSource == null) {
                throw new KsqlException(table.getName().getSuffix() + " does not exist.");
            }
            return null;
        }
        return new AliasedRelation(DataSourceExtractor.getLocation(context), (Relation)table, alias.toUpperCase(), DataSourceExtractor.getColumnAliases(context.columnAliases()));
    }

    @Override
    public Node visitJoinRelation(SqlBaseParser.JoinRelationContext context) {
        this.isJoin = true;
        AliasedRelation left = (AliasedRelation)this.visit((ParseTree)context.left);
        AliasedRelation right = context.CROSS() != null ? (AliasedRelation)this.visit((ParseTree)context.right) : (context.NATURAL() != null ? (AliasedRelation)this.visit((ParseTree)context.right) : (AliasedRelation)this.visit((ParseTree)context.rightRelation));
        this.leftAlias = left.getAlias();
        StructuredDataSource leftDataSource = this.metaStore.getSource(((Table)left.getRelation()).getName().getSuffix());
        if (leftDataSource == null) {
            throw new KsqlException(((Table)left.getRelation()).getName().getSuffix() + " does not " + "exist.");
        }
        this.joinLeftSchema = leftDataSource.getSchema();
        this.rightAlias = right.getAlias();
        StructuredDataSource rightDataSource = this.metaStore.getSource(((Table)right.getRelation()).getName().getSuffix());
        if (rightDataSource == null) {
            throw new KsqlException(((Table)right.getRelation()).getName().getSuffix() + " does not " + "exist.");
        }
        this.joinRightSchema = rightDataSource.getSchema();
        return null;
    }

    public void extractDataSources(ParseTree node) {
        this.visit(node);
        if (this.joinLeftSchema != null) {
            for (Field field : this.joinLeftSchema.fields()) {
                this.leftFieldNames.add(field.name());
            }
            for (Field field : this.joinRightSchema.fields()) {
                this.rightFieldNames.add(field.name());
                if (!this.leftFieldNames.contains(field.name())) continue;
                this.commonFieldNames.add(field.name());
            }
        }
    }

    public MetaStore getMetaStore() {
        return this.metaStore;
    }

    public Schema getJoinLeftSchema() {
        return this.joinLeftSchema;
    }

    public String getFromAlias() {
        return this.fromAlias;
    }

    public String getLeftAlias() {
        return this.leftAlias;
    }

    public String getRightAlias() {
        return this.rightAlias;
    }

    public Set<String> getCommonFieldNames() {
        return this.commonFieldNames;
    }

    public Set<String> getLeftFieldNames() {
        return this.leftFieldNames;
    }

    public Set<String> getRightFieldNames() {
        return this.rightFieldNames;
    }

    private static QualifiedName getQualifiedName(SqlBaseParser.QualifiedNameContext context) {
        List<String> parts = context.identifier().stream().map(AstBuilder::getIdentifierText).collect(Collectors.toList());
        return QualifiedName.of(parts);
    }

    private static List<String> getColumnAliases(SqlBaseParser.ColumnAliasesContext columnAliasesContext) {
        if (columnAliasesContext == null) {
            return null;
        }
        return columnAliasesContext.identifier().stream().map(AstBuilder::getIdentifierText).collect(Collectors.toList());
    }

    private static NodeLocation getLocation(ParserRuleContext parserRuleContext) {
        Objects.requireNonNull(parserRuleContext, "parserRuleContext is null");
        return DataSourceExtractor.getLocation(parserRuleContext.getStart());
    }

    private static NodeLocation getLocation(Token token) {
        Objects.requireNonNull(token, "token is null");
        return new NodeLocation(token.getLine(), token.getCharPositionInLine());
    }
}

