/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.common.base.MoreObjects;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.Node;
import io.confluent.ksql.parser.tree.NodeLocation;
import io.confluent.ksql.parser.tree.QualifiedName;
import io.confluent.ksql.parser.tree.Query;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class WithQuery
extends Node {
    private final String name;
    private final Query query;
    private final Optional<List<String>> columnNames;

    public WithQuery(String name, Query query, Optional<List<String>> columnNames) {
        this(Optional.empty(), name, query, columnNames);
    }

    public WithQuery(NodeLocation location, String name, Query query, Optional<List<String>> columnNames) {
        this(Optional.of(location), name, query, columnNames);
    }

    private WithQuery(Optional<NodeLocation> location, String name, Query query, Optional<List<String>> columnNames) {
        super(location);
        this.name = QualifiedName.of(Objects.requireNonNull(name, "name is null")).getParts().get(0);
        this.query = Objects.requireNonNull(query, "query is null");
        this.columnNames = Objects.requireNonNull(columnNames, "columnNames is null");
    }

    public String getName() {
        return this.name;
    }

    public Query getQuery() {
        return this.query;
    }

    public Optional<List<String>> getColumnNames() {
        return this.columnNames;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitWithQuery(this, context);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("query", (Object)this.query).add("columnNames", this.columnNames).omitNullValues().toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.query, this.columnNames);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        WithQuery o = (WithQuery)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.query, o.query) && Objects.equals(this.columnNames, o.columnNames);
    }
}

