/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.Node;
import io.confluent.ksql.parser.tree.NodeLocation;
import io.confluent.ksql.parser.tree.WindowExpression;
import java.util.Objects;
import java.util.Optional;

public class Window
extends Node {
    private final WindowExpression windowExpression;

    public Window(String windowName, WindowExpression windowExpression) {
        this(Optional.empty(), windowName, windowExpression);
    }

    public Window(NodeLocation location, String windowName, WindowExpression windowExpression) {
        this(Optional.of(location), windowName, windowExpression);
    }

    private Window(Optional<NodeLocation> location, String windowName, WindowExpression windowExpression) {
        super(location);
        this.windowExpression = Objects.requireNonNull(windowExpression, "windowExpression is null");
    }

    public WindowExpression getWindowExpression() {
        return this.windowExpression;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitWindow(this, context);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Window o = (Window)obj;
        return Objects.equals(this.windowExpression, o.windowExpression);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.windowExpression);
    }

    @Override
    public String toString() {
        return " WINDOW " + this.windowExpression.toString();
    }
}

