/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.common.base.MoreObjects;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.Node;
import io.confluent.ksql.parser.tree.NodeLocation;
import java.util.Objects;
import java.util.Optional;

public final class TableElement
extends Node {
    private final String name;
    private final String type;

    public TableElement(String name, String type) {
        this(Optional.empty(), name, type);
    }

    public TableElement(NodeLocation location, String name, String type) {
        this(Optional.of(location), name, type);
    }

    private TableElement(Optional<NodeLocation> location, String name, String type) {
        super(location);
        this.name = Objects.requireNonNull(name, "name is null");
        this.type = Objects.requireNonNull(type, "type is null");
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitTableElement(this, context);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TableElement o = (TableElement)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.type, o.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.type);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("type", (Object)this.type).toString();
    }
}

