/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.Expression;
import io.confluent.ksql.parser.tree.NodeLocation;
import io.confluent.ksql.parser.tree.QualifiedName;
import io.confluent.ksql.parser.tree.QueryBody;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class Table
extends QueryBody {
    public final boolean isStdOut;
    private final Map<String, Expression> properties = new HashMap<String, Expression>();
    private final QualifiedName name;

    public Table(QualifiedName name) {
        this(Optional.empty(), name, false);
    }

    public Table(QualifiedName name, boolean isStdOut) {
        this(Optional.empty(), name, isStdOut);
    }

    public Table(NodeLocation location, QualifiedName name) {
        this(Optional.of(location), name, false);
    }

    public Table(NodeLocation location, QualifiedName name, boolean isStdOut) {
        this(Optional.of(location), name, isStdOut);
    }

    private Table(Optional<NodeLocation> location, QualifiedName name, boolean isStdOut) {
        super(location);
        this.name = name;
        this.isStdOut = isStdOut;
    }

    public QualifiedName getName() {
        return this.name;
    }

    public boolean isStdOut() {
        return this.isStdOut;
    }

    public Map<String, Expression> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Expression> properties) {
        this.properties.clear();
        this.properties.putAll(properties);
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitTable(this, context);
    }

    @Override
    public String toString() {
        return this.name.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Table table = (Table)o;
        return Objects.equals(this.name, table.name);
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }
}

