/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.common.base.MoreObjects;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.Expression;
import io.confluent.ksql.parser.tree.NodeLocation;
import io.confluent.ksql.parser.tree.QualifiedName;
import io.confluent.ksql.parser.tree.Statement;
import java.util.Objects;
import java.util.Optional;

public class ShowPartitions
extends Statement {
    private final QualifiedName table;
    private final Optional<Expression> where;
    private final Optional<String> limit;

    public ShowPartitions(QualifiedName table, Optional<Expression> where, Optional<String> limit) {
        this(Optional.empty(), table, where, limit);
    }

    public ShowPartitions(NodeLocation location, QualifiedName table, Optional<Expression> where, Optional<String> limit) {
        this(Optional.of(location), table, where, limit);
    }

    private ShowPartitions(Optional<NodeLocation> location, QualifiedName table, Optional<Expression> where, Optional<String> limit) {
        super(location);
        this.table = Objects.requireNonNull(table, "table is null");
        this.where = Objects.requireNonNull(where, "where is null");
        this.limit = Objects.requireNonNull(limit, "limit is null");
    }

    public QualifiedName getTable() {
        return this.table;
    }

    public Optional<Expression> getWhere() {
        return this.where;
    }

    public Optional<String> getLimit() {
        return this.limit;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitShowPartitions(this, context);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.table, this.where, this.limit);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ShowPartitions o = (ShowPartitions)obj;
        return Objects.equals(this.table, o.table) && Objects.equals(this.where, o.where) && Objects.equals(this.limit, o.limit);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("table", (Object)this.table).add("where", this.where).add("limit", this.limit).toString();
    }
}

