/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.common.base.MoreObjects;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.NodeLocation;
import io.confluent.ksql.parser.tree.QualifiedName;
import io.confluent.ksql.parser.tree.Statement;
import java.util.Objects;
import java.util.Optional;

public class ShowColumns
extends Statement {
    private final QualifiedName table;
    private final boolean isTopic;
    private final boolean isExtended;

    public ShowColumns(QualifiedName table, boolean isTopic, boolean isExtended) {
        this(Optional.empty(), table, isTopic, isExtended);
    }

    public ShowColumns(NodeLocation location, QualifiedName table, boolean isTopic, boolean isExtended) {
        this(Optional.of(location), table, isTopic, isExtended);
    }

    private ShowColumns(Optional<NodeLocation> location, QualifiedName table, boolean isTopic, boolean isExtended) {
        super(location);
        this.table = Objects.requireNonNull(table, "table is null");
        this.isTopic = isTopic;
        this.isExtended = isExtended;
    }

    public QualifiedName getTable() {
        return this.table;
    }

    public boolean isTopic() {
        return this.isTopic;
    }

    public boolean isExtended() {
        return this.isExtended;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitShowColumns(this, context);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.table);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ShowColumns o = (ShowColumns)obj;
        return Objects.equals(this.table, o.table);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("table", (Object)this.table).toString();
    }
}

