/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.common.base.MoreObjects;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.Expression;
import io.confluent.ksql.parser.tree.NodeLocation;
import io.confluent.ksql.parser.tree.QualifiedName;
import io.confluent.ksql.parser.tree.Statement;
import java.util.Objects;
import java.util.Optional;

public class SetSession
extends Statement {
    private final QualifiedName name;
    private final Expression value;

    public SetSession(QualifiedName name, Expression value) {
        this(Optional.empty(), name, value);
    }

    public SetSession(NodeLocation location, QualifiedName name, Expression value) {
        this(Optional.of(location), name, value);
    }

    private SetSession(Optional<NodeLocation> location, QualifiedName name, Expression value) {
        super(location);
        this.name = name;
        this.value = value;
    }

    public QualifiedName getName() {
        return this.name;
    }

    public Expression getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSetSession(this, context);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SetSession o = (SetSession)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.value, o.value);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("value", (Object)this.value).toString();
    }
}

