/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.common.base.MoreObjects;
import io.confluent.ksql.parser.tree.DDLStatement;
import io.confluent.ksql.parser.tree.NodeLocation;
import io.confluent.ksql.parser.tree.Statement;
import java.util.Objects;
import java.util.Optional;

public class SetProperty
extends Statement
implements DDLStatement {
    private final String propertyName;
    private final String propertyValue;

    public SetProperty(Optional<NodeLocation> location, String propertyName, String propertyValue) {
        super(location);
        Objects.requireNonNull(propertyName, "propertyName is null");
        Objects.requireNonNull(propertyValue, "propertyValue is null");
        this.propertyName = propertyName;
        this.propertyValue = propertyValue;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getPropertyValue() {
        return this.propertyValue;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.propertyName, this.propertyValue);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetProperty setProperty = (SetProperty)o;
        if (!this.propertyName.equals(setProperty.propertyName)) {
            return false;
        }
        return this.propertyValue.equals(setProperty.propertyValue);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).toString();
    }
}

