/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import io.confluent.ksql.GenericRow;
import io.confluent.ksql.function.UdafAggregator;
import io.confluent.ksql.parser.tree.KsqlWindowExpression;
import io.confluent.ksql.parser.tree.NodeLocation;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.streams.kstream.Aggregator;
import org.apache.kafka.streams.kstream.Initializer;
import org.apache.kafka.streams.kstream.KGroupedStream;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.SessionWindows;

public class SessionWindowExpression
extends KsqlWindowExpression {
    private final long gap;
    private final TimeUnit sizeUnit;

    public SessionWindowExpression(long gap, TimeUnit sizeUnit) {
        this(Optional.empty(), gap, sizeUnit);
    }

    private SessionWindowExpression(Optional<NodeLocation> location, long gap, TimeUnit sizeUnit) {
        super(location);
        this.gap = gap;
        this.sizeUnit = sizeUnit;
    }

    @Override
    public String toString() {
        return " SESSION ( " + this.gap + " " + (Object)((Object)this.sizeUnit) + " ) ";
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.gap, this.sizeUnit});
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionWindowExpression sessionWindowExpression = (SessionWindowExpression)o;
        return sessionWindowExpression.gap == this.gap && sessionWindowExpression.sizeUnit == this.sizeUnit;
    }

    @Override
    public KTable applyAggregate(KGroupedStream groupedStream, Initializer initializer, UdafAggregator aggregator, Materialized<String, GenericRow, ?> materialized) {
        return groupedStream.windowedBy(SessionWindows.with((long)this.sizeUnit.toMillis(this.gap))).aggregate(initializer, (Aggregator)aggregator, aggregator.getMerger(), materialized);
    }
}

