/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.common.collect.ImmutableList;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.Expression;
import io.confluent.ksql.parser.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class Row
extends Expression {
    private final List<Expression> items;

    public Row(List<Expression> items) {
        this(Optional.empty(), items);
    }

    public Row(NodeLocation location, List<Expression> items) {
        this(Optional.of(location), items);
    }

    private Row(Optional<NodeLocation> location, List<Expression> items) {
        super(location);
        Objects.requireNonNull(items, "items is null");
        this.items = ImmutableList.copyOf(items);
    }

    public List<Expression> getItems() {
        return this.items;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitRow(this, context);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.items);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Row other = (Row)obj;
        return Objects.equals(this.items, other.items);
    }
}

