/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.common.base.MoreObjects;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.NodeLocation;
import io.confluent.ksql.parser.tree.QualifiedName;
import io.confluent.ksql.parser.tree.Statement;
import java.util.Objects;
import java.util.Optional;

public class RenameColumn
extends Statement {
    private final QualifiedName table;
    private final String source;
    private final String target;

    public RenameColumn(QualifiedName table, String source, String target) {
        this(Optional.empty(), table, source, target);
    }

    public RenameColumn(NodeLocation location, QualifiedName table, String source, String target) {
        this(Optional.of(location), table, source, target);
    }

    private RenameColumn(Optional<NodeLocation> location, QualifiedName table, String source, String target) {
        super(location);
        this.table = Objects.requireNonNull(table, "table is null");
        this.source = Objects.requireNonNull(source, "source is null");
        this.target = Objects.requireNonNull(target, "target is null");
    }

    public QualifiedName getTable() {
        return this.table;
    }

    public String getSource() {
        return this.source;
    }

    public String getTarget() {
        return this.target;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitRenameColumn(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RenameColumn that = (RenameColumn)o;
        return Objects.equals(this.table, that.table) && Objects.equals(this.source, that.source) && Objects.equals(this.target, that.target);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.table, this.source, this.target);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("table", (Object)this.table).add("source", (Object)this.source).add("target", (Object)this.target).toString();
    }
}

