/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.common.base.MoreObjects;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.Expression;
import io.confluent.ksql.parser.tree.GroupBy;
import io.confluent.ksql.parser.tree.NodeLocation;
import io.confluent.ksql.parser.tree.QueryBody;
import io.confluent.ksql.parser.tree.Relation;
import io.confluent.ksql.parser.tree.Select;
import io.confluent.ksql.parser.tree.WindowExpression;
import java.util.Objects;
import java.util.Optional;

public class QuerySpecification
extends QueryBody {
    private final Select select;
    private final Relation into;
    private final Relation from;
    private final Optional<WindowExpression> windowExpression;
    private final Optional<Expression> where;
    private final Optional<GroupBy> groupBy;
    private final Optional<Expression> having;
    private final Optional<String> limit;

    public QuerySpecification(Select select, Relation into, Relation from, Optional<WindowExpression> windowExpression, Optional<Expression> where, Optional<GroupBy> groupBy, Optional<Expression> having, Optional<String> limit) {
        this(Optional.empty(), select, into, from, windowExpression, where, groupBy, having, limit);
    }

    public QuerySpecification(NodeLocation location, Select select, Relation into, Relation from, Optional<WindowExpression> windowExpression, Optional<Expression> where, Optional<GroupBy> groupBy, Optional<Expression> having, Optional<String> limit) {
        this(Optional.of(location), select, into, from, windowExpression, where, groupBy, having, limit);
    }

    private QuerySpecification(Optional<NodeLocation> location, Select select, Relation into, Relation from, Optional<WindowExpression> windowExpression, Optional<Expression> where, Optional<GroupBy> groupBy, Optional<Expression> having, Optional<String> limit) {
        super(location);
        Objects.requireNonNull(select, "select is null");
        Objects.requireNonNull(into, "into is null");
        Objects.requireNonNull(from, "from is null");
        Objects.requireNonNull(windowExpression, "window is null");
        Objects.requireNonNull(where, "where is null");
        Objects.requireNonNull(groupBy, "groupBy is null");
        Objects.requireNonNull(having, "having is null");
        Objects.requireNonNull(limit, "limit is null");
        this.select = select;
        this.into = into;
        this.from = from;
        this.windowExpression = windowExpression;
        this.where = where;
        this.groupBy = groupBy;
        this.having = having;
        this.limit = limit;
    }

    public Select getSelect() {
        return this.select;
    }

    public Relation getInto() {
        return this.into;
    }

    public Relation getFrom() {
        return this.from;
    }

    public Optional<WindowExpression> getWindowExpression() {
        return this.windowExpression;
    }

    public Optional<Expression> getWhere() {
        return this.where;
    }

    public Optional<GroupBy> getGroupBy() {
        return this.groupBy;
    }

    public Optional<Expression> getHaving() {
        return this.having;
    }

    public Optional<String> getLimit() {
        return this.limit;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitQuerySpecification(this, context);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("select", (Object)this.select).add("from", (Object)this.from).add("", this.windowExpression.orElse(null)).add("where", this.where.orElse(null)).add("groupBy", this.groupBy).add("having", this.having.orElse(null)).add("limit", this.limit.orElse(null)).toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QuerySpecification o = (QuerySpecification)obj;
        return Objects.equals(this.select, o.select) && Objects.equals(this.from, o.from) && Objects.equals(this.where, o.where) && Objects.equals(this.groupBy, o.groupBy) && Objects.equals(this.having, o.having) && Objects.equals(this.limit, o.limit);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.select, this.from, this.where, this.groupBy, this.having, this.limit);
    }
}

