/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class QualifiedName {
    private final List<String> parts;

    public static QualifiedName of(String first, String ... rest) {
        Objects.requireNonNull(first, "first is null");
        return QualifiedName.of((Iterable<String>)ImmutableList.copyOf((Collection)Lists.asList((Object)first, (Object[])rest)));
    }

    public static QualifiedName of(String name) {
        Objects.requireNonNull(name, "name is null");
        return QualifiedName.of((Iterable<String>)ImmutableList.of((Object)name));
    }

    public static QualifiedName of(Iterable<String> parts) {
        Objects.requireNonNull(parts, "parts is null");
        Preconditions.checkArgument((!Iterables.isEmpty(parts) ? 1 : 0) != 0, (Object)"parts is empty");
        return new QualifiedName((List<String>)ImmutableList.copyOf(parts));
    }

    private QualifiedName(List<String> parts) {
        this.parts = parts;
    }

    public List<String> getParts() {
        return this.parts;
    }

    public String toString() {
        return Joiner.on((char)'.').join(this.parts);
    }

    public Optional<QualifiedName> getPrefix() {
        if (this.parts.size() == 1) {
            return Optional.empty();
        }
        List<String> subList = this.parts.subList(0, this.parts.size() - 1);
        return Optional.of(new QualifiedName(subList));
    }

    public boolean hasSuffix(QualifiedName suffix) {
        if (this.parts.size() < suffix.getParts().size()) {
            return false;
        }
        int start = this.parts.size() - suffix.getParts().size();
        return this.parts.subList(start, this.parts.size()).equals(suffix.getParts());
    }

    public String getSuffix() {
        return (String)Iterables.getLast(this.parts);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.parts.equals(((QualifiedName)o).parts);
    }

    public int hashCode() {
        return this.parts.hashCode();
    }
}

