/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.Expression;
import io.confluent.ksql.parser.tree.NodeLocation;
import java.util.Objects;
import java.util.Optional;

public class NullIfExpression
extends Expression {
    private final Expression first;
    private final Expression second;

    public NullIfExpression(Expression first, Expression second) {
        this(Optional.empty(), first, second);
    }

    public NullIfExpression(NodeLocation location, Expression first, Expression second) {
        this(Optional.of(location), first, second);
    }

    private NullIfExpression(Optional<NodeLocation> location, Expression first, Expression second) {
        super(location);
        this.first = first;
        this.second = second;
    }

    public Expression getFirst() {
        return this.first;
    }

    public Expression getSecond() {
        return this.second;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitNullIfExpression(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NullIfExpression that = (NullIfExpression)o;
        return Objects.equals(this.first, that.first) && Objects.equals(this.second, that.second);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.first, this.second);
    }
}

