/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.Expression;
import io.confluent.ksql.parser.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class LambdaExpression
extends Expression {
    private final List<String> arguments;
    private final Expression body;

    public LambdaExpression(List<String> arguments, Expression body) {
        this(Optional.empty(), arguments, body);
    }

    public LambdaExpression(NodeLocation location, List<String> arguments, Expression body) {
        this(Optional.of(location), arguments, body);
    }

    private LambdaExpression(Optional<NodeLocation> location, List<String> arguments, Expression body) {
        super(location);
        this.arguments = Objects.requireNonNull(arguments, "arguments is null");
        this.body = Objects.requireNonNull(body, "body is null");
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public Expression getBody() {
        return this.body;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitLambdaExpression(this, context);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LambdaExpression that = (LambdaExpression)obj;
        return Objects.equals(this.arguments, that.arguments) && Objects.equals(this.body, that.body);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.arguments, this.body);
    }
}

