/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.Expression;
import io.confluent.ksql.parser.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class InListExpression
extends Expression {
    private final List<Expression> values;

    public InListExpression(List<Expression> values) {
        this(Optional.empty(), values);
    }

    public InListExpression(NodeLocation location, List<Expression> values) {
        this(Optional.of(location), values);
    }

    private InListExpression(Optional<NodeLocation> location, List<Expression> values) {
        super(location);
        this.values = values;
    }

    public List<Expression> getValues() {
        return this.values;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitInListExpression(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InListExpression that = (InListExpression)o;
        return Objects.equals(this.values, that.values);
    }

    @Override
    public int hashCode() {
        return this.values.hashCode();
    }
}

