/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import io.confluent.ksql.GenericRow;
import io.confluent.ksql.function.UdafAggregator;
import io.confluent.ksql.parser.tree.KsqlWindowExpression;
import io.confluent.ksql.parser.tree.NodeLocation;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.streams.kstream.Aggregator;
import org.apache.kafka.streams.kstream.Initializer;
import org.apache.kafka.streams.kstream.KGroupedStream;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.TimeWindows;
import org.apache.kafka.streams.kstream.Windows;

public class HoppingWindowExpression
extends KsqlWindowExpression {
    private final long size;
    private final TimeUnit sizeUnit;
    private final long advanceBy;
    private final TimeUnit advanceByUnit;

    public HoppingWindowExpression(long size, TimeUnit sizeUnit, long advanceBy, TimeUnit advanceByUnit) {
        this(Optional.empty(), size, sizeUnit, advanceBy, advanceByUnit);
    }

    private HoppingWindowExpression(Optional<NodeLocation> location, long size, TimeUnit sizeUnit, long advanceBy, TimeUnit advanceByUnit) {
        super(location);
        this.size = size;
        this.sizeUnit = sizeUnit;
        this.advanceBy = advanceBy;
        this.advanceByUnit = advanceByUnit;
    }

    @Override
    public String toString() {
        return " HOPPING ( SIZE " + this.size + " " + (Object)((Object)this.sizeUnit) + " , ADVANCE BY " + this.advanceBy + " " + "" + (Object)((Object)this.advanceByUnit) + " ) ";
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.size, this.sizeUnit, this.advanceBy, this.advanceByUnit});
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HoppingWindowExpression hoppingWindowExpression = (HoppingWindowExpression)o;
        return hoppingWindowExpression.size == this.size && hoppingWindowExpression.sizeUnit == this.sizeUnit && hoppingWindowExpression.advanceBy == this.advanceBy && hoppingWindowExpression.advanceByUnit == this.advanceByUnit;
    }

    @Override
    public KTable applyAggregate(KGroupedStream groupedStream, Initializer initializer, UdafAggregator aggregator, Materialized<String, GenericRow, ?> materialized) {
        return groupedStream.windowedBy((Windows)TimeWindows.of((long)this.sizeUnit.toMillis(this.size)).advanceBy(this.advanceByUnit.toMillis(this.advanceBy))).aggregate(initializer, (Aggregator)aggregator, materialized);
    }
}

