/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.Expression;
import io.confluent.ksql.parser.tree.NodeLocation;
import io.confluent.ksql.parser.tree.QualifiedName;
import io.confluent.ksql.parser.tree.Window;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class FunctionCall
extends Expression {
    private final QualifiedName name;
    private final Optional<Window> window;
    private final boolean distinct;
    private final List<Expression> arguments;

    public FunctionCall(QualifiedName name, List<Expression> arguments) {
        this(Optional.empty(), name, Optional.empty(), false, arguments);
    }

    public FunctionCall(NodeLocation location, QualifiedName name, List<Expression> arguments) {
        this(Optional.of(location), name, Optional.empty(), false, arguments);
    }

    public FunctionCall(QualifiedName name, boolean distinct, List<Expression> arguments) {
        this(Optional.empty(), name, Optional.empty(), distinct, arguments);
    }

    public FunctionCall(NodeLocation location, QualifiedName name, boolean distinct, List<Expression> arguments) {
        this(Optional.of(location), name, Optional.empty(), distinct, arguments);
    }

    public FunctionCall(QualifiedName name, Optional<Window> window, boolean distinct, List<Expression> arguments) {
        this(Optional.empty(), name, window, distinct, arguments);
    }

    public FunctionCall(NodeLocation location, QualifiedName name, Optional<Window> window, boolean distinct, List<Expression> arguments) {
        this(Optional.of(location), name, window, distinct, arguments);
    }

    private FunctionCall(Optional<NodeLocation> location, QualifiedName name, Optional<Window> window, boolean distinct, List<Expression> arguments) {
        super(location);
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(window, "window is null");
        Objects.requireNonNull(arguments, "arguments is null");
        this.name = name;
        this.window = window;
        this.distinct = distinct;
        this.arguments = arguments;
    }

    public QualifiedName getName() {
        return this.name;
    }

    public Optional<Window> getWindow() {
        return this.window;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public List<Expression> getArguments() {
        return this.arguments;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitFunctionCall(this, context);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionCall o = (FunctionCall)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.window, o.window) && Objects.equals(this.distinct, o.distinct) && Objects.equals(this.arguments, o.arguments);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.distinct, this.window, this.arguments);
    }
}

