/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.confluent.ksql.parser.tree.ArithmeticBinaryExpression;
import io.confluent.ksql.parser.tree.ArithmeticUnaryExpression;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.BetweenPredicate;
import io.confluent.ksql.parser.tree.Cast;
import io.confluent.ksql.parser.tree.ComparisonExpression;
import io.confluent.ksql.parser.tree.DereferenceExpression;
import io.confluent.ksql.parser.tree.ExistsPredicate;
import io.confluent.ksql.parser.tree.Expression;
import io.confluent.ksql.parser.tree.ExpressionRewriter;
import io.confluent.ksql.parser.tree.Extract;
import io.confluent.ksql.parser.tree.FieldReference;
import io.confluent.ksql.parser.tree.FunctionCall;
import io.confluent.ksql.parser.tree.InListExpression;
import io.confluent.ksql.parser.tree.InPredicate;
import io.confluent.ksql.parser.tree.IsNotNullPredicate;
import io.confluent.ksql.parser.tree.IsNullPredicate;
import io.confluent.ksql.parser.tree.LambdaExpression;
import io.confluent.ksql.parser.tree.LikePredicate;
import io.confluent.ksql.parser.tree.Literal;
import io.confluent.ksql.parser.tree.LogicalBinaryExpression;
import io.confluent.ksql.parser.tree.NotExpression;
import io.confluent.ksql.parser.tree.NullIfExpression;
import io.confluent.ksql.parser.tree.QualifiedNameReference;
import io.confluent.ksql.parser.tree.Row;
import io.confluent.ksql.parser.tree.SearchedCaseExpression;
import io.confluent.ksql.parser.tree.SimpleCaseExpression;
import io.confluent.ksql.parser.tree.SubqueryExpression;
import io.confluent.ksql.parser.tree.SubscriptExpression;
import io.confluent.ksql.parser.tree.SymbolReference;
import io.confluent.ksql.parser.tree.WhenClause;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public final class ExpressionTreeRewriter<C> {
    private final ExpressionRewriter<C> rewriter;
    private final AstVisitor<Expression, Context<C>> visitor;

    public static <C, T extends Expression> T rewriteWith(ExpressionRewriter<C> rewriter, T node) {
        return new ExpressionTreeRewriter<Object>(rewriter).rewrite(node, null);
    }

    public ExpressionTreeRewriter(ExpressionRewriter<C> rewriter) {
        this.rewriter = rewriter;
        this.visitor = new RewritingVisitor();
    }

    public <T extends Expression> T rewrite(T node, C context) {
        return (T)this.visitor.process(node, new Context(context, false));
    }

    private static <T> boolean sameElements(Optional<T> a, Optional<T> b) {
        if (!a.isPresent() && !b.isPresent()) {
            return true;
        }
        if (a.isPresent() != b.isPresent()) {
            return false;
        }
        return a.get() == b.get();
    }

    private static <T> boolean sameElements(Iterable<? extends T> a, Iterable<? extends T> b) {
        if (Iterables.size(a) != Iterables.size(b)) {
            return false;
        }
        Iterator<T> first = a.iterator();
        Iterator<T> second = b.iterator();
        while (first.hasNext() && second.hasNext()) {
            if (first.next() == second.next()) continue;
            return false;
        }
        return true;
    }

    public static class Context<C> {
        private final boolean defaultRewrite;
        private final C context;

        private Context(C context, boolean defaultRewrite) {
            this.context = context;
            this.defaultRewrite = defaultRewrite;
        }

        public C get() {
            return this.context;
        }

        public boolean isDefaultRewrite() {
            return this.defaultRewrite;
        }
    }

    private class RewritingVisitor
    extends AstVisitor<Expression, Context<C>> {
        private RewritingVisitor() {
        }

        @Override
        protected Expression visitExpression(Expression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            throw new UnsupportedOperationException("not yet implemented: " + this.getClass().getSimpleName() + " for " + node.getClass().getName());
        }

        @Override
        protected Expression visitRow(Row node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteRow(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Expression expression : node.getItems()) {
                builder.add((Object)ExpressionTreeRewriter.this.rewrite(expression, context.get()));
            }
            if (!ExpressionTreeRewriter.sameElements(node.getItems(), (Iterable)builder.build())) {
                return new Row((List<Expression>)builder.build());
            }
            return node;
        }

        @Override
        protected Expression visitArithmeticUnary(ArithmeticUnaryExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteArithmeticUnary(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression child = ExpressionTreeRewriter.this.rewrite(node.getValue(), context.get());
            if (child != node.getValue()) {
                return new ArithmeticUnaryExpression(node.getSign(), child);
            }
            return node;
        }

        @Override
        public Expression visitArithmeticBinary(ArithmeticBinaryExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteArithmeticBinary(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression left = ExpressionTreeRewriter.this.rewrite(node.getLeft(), context.get());
            Expression right = ExpressionTreeRewriter.this.rewrite(node.getRight(), context.get());
            if (left != node.getLeft() || right != node.getRight()) {
                return new ArithmeticBinaryExpression(node.getType(), left, right);
            }
            return node;
        }

        @Override
        protected Expression visitSubscriptExpression(SubscriptExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteSubscriptExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression base = ExpressionTreeRewriter.this.rewrite(node.getBase(), context.get());
            Expression index = ExpressionTreeRewriter.this.rewrite(node.getIndex(), context.get());
            if (base != node.getBase() || index != node.getIndex()) {
                return new SubscriptExpression(base, index);
            }
            return node;
        }

        @Override
        public Expression visitComparisonExpression(ComparisonExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteComparisonExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression left = ExpressionTreeRewriter.this.rewrite(node.getLeft(), context.get());
            Expression right = ExpressionTreeRewriter.this.rewrite(node.getRight(), context.get());
            if (left != node.getLeft() || right != node.getRight()) {
                return new ComparisonExpression(node.getType(), left, right);
            }
            return node;
        }

        @Override
        protected Expression visitBetweenPredicate(BetweenPredicate node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteBetweenPredicate(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression value = ExpressionTreeRewriter.this.rewrite(node.getValue(), context.get());
            Expression min = ExpressionTreeRewriter.this.rewrite(node.getMin(), context.get());
            Expression max = ExpressionTreeRewriter.this.rewrite(node.getMax(), context.get());
            if (value != node.getValue() || min != node.getMin() || max != node.getMax()) {
                return new BetweenPredicate(value, min, max);
            }
            return node;
        }

        @Override
        public Expression visitLogicalBinaryExpression(LogicalBinaryExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteLogicalBinaryExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression left = ExpressionTreeRewriter.this.rewrite(node.getLeft(), context.get());
            Expression right = ExpressionTreeRewriter.this.rewrite(node.getRight(), context.get());
            if (left != node.getLeft() || right != node.getRight()) {
                return new LogicalBinaryExpression(node.getType(), left, right);
            }
            return node;
        }

        @Override
        public Expression visitNotExpression(NotExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteNotExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression value = ExpressionTreeRewriter.this.rewrite(node.getValue(), context.get());
            if (value != node.getValue()) {
                return new NotExpression(value);
            }
            return node;
        }

        @Override
        protected Expression visitIsNullPredicate(IsNullPredicate node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteIsNullPredicate(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression value = ExpressionTreeRewriter.this.rewrite(node.getValue(), context.get());
            if (value != node.getValue()) {
                return new IsNullPredicate(value);
            }
            return node;
        }

        @Override
        protected Expression visitIsNotNullPredicate(IsNotNullPredicate node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteIsNotNullPredicate(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression value = ExpressionTreeRewriter.this.rewrite(node.getValue(), context.get());
            if (value != node.getValue()) {
                return new IsNotNullPredicate(value);
            }
            return node;
        }

        @Override
        protected Expression visitNullIfExpression(NullIfExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteNullIfExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression first = ExpressionTreeRewriter.this.rewrite(node.getFirst(), context.get());
            Expression second = ExpressionTreeRewriter.this.rewrite(node.getSecond(), context.get());
            if (first != node.getFirst() || second != node.getSecond()) {
                return new NullIfExpression(first, second);
            }
            return node;
        }

        @Override
        protected Expression visitSearchedCaseExpression(SearchedCaseExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteSearchedCaseExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (WhenClause expression : node.getWhenClauses()) {
                builder.add((Object)ExpressionTreeRewriter.this.rewrite(expression, context.get()));
            }
            Optional<Expression> defaultValue = node.getDefaultValue().map(value -> ExpressionTreeRewriter.this.rewrite(value, context.get()));
            if (!ExpressionTreeRewriter.sameElements(node.getDefaultValue(), defaultValue) || !ExpressionTreeRewriter.sameElements(node.getWhenClauses(), (Iterable)builder.build())) {
                return new SearchedCaseExpression((List<WhenClause>)builder.build(), defaultValue);
            }
            return node;
        }

        @Override
        protected Expression visitSimpleCaseExpression(SimpleCaseExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteSimpleCaseExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression operand = ExpressionTreeRewriter.this.rewrite(node.getOperand(), context.get());
            ImmutableList.Builder builder = ImmutableList.builder();
            for (WhenClause expression : node.getWhenClauses()) {
                builder.add((Object)ExpressionTreeRewriter.this.rewrite(expression, context.get()));
            }
            Optional<Expression> defaultValue = node.getDefaultValue().map(value -> ExpressionTreeRewriter.this.rewrite(value, context.get()));
            if (operand != node.getOperand() || !ExpressionTreeRewriter.sameElements(node.getDefaultValue(), defaultValue) || !ExpressionTreeRewriter.sameElements(node.getWhenClauses(), (Iterable)builder.build())) {
                return new SimpleCaseExpression(operand, (List<WhenClause>)builder.build(), defaultValue);
            }
            return node;
        }

        @Override
        protected Expression visitWhenClause(WhenClause node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteWhenClause(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression operand = ExpressionTreeRewriter.this.rewrite(node.getOperand(), context.get());
            Expression result2 = ExpressionTreeRewriter.this.rewrite(node.getResult(), context.get());
            if (operand != node.getOperand() || result2 != node.getResult()) {
                return new WhenClause(operand, result2);
            }
            return node;
        }

        @Override
        public Expression visitFunctionCall(FunctionCall node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteFunctionCall(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return node;
        }

        @Override
        protected Expression visitLambdaExpression(LambdaExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteLambdaExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression body = ExpressionTreeRewriter.this.rewrite(node.getBody(), context.get());
            if (body != node.getBody()) {
                return new LambdaExpression(node.getArguments(), body);
            }
            return node;
        }

        @Override
        public Expression visitLikePredicate(LikePredicate node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteLikePredicate(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression value = ExpressionTreeRewriter.this.rewrite(node.getValue(), context.get());
            Expression pattern = ExpressionTreeRewriter.this.rewrite(node.getPattern(), context.get());
            Expression escape = null;
            if (node.getEscape() != null) {
                escape = ExpressionTreeRewriter.this.rewrite(node.getEscape(), context.get());
            }
            if (value != node.getValue() || pattern != node.getPattern() || escape != node.getEscape()) {
                return new LikePredicate(value, pattern, escape);
            }
            return node;
        }

        @Override
        public Expression visitInPredicate(InPredicate node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteInPredicate(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression value = ExpressionTreeRewriter.this.rewrite(node.getValue(), context.get());
            Expression list = ExpressionTreeRewriter.this.rewrite(node.getValueList(), context.get());
            if (node.getValue() != value || node.getValueList() != list) {
                return new InPredicate(value, list);
            }
            return node;
        }

        @Override
        protected Expression visitInListExpression(InListExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteInListExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Expression expression : node.getValues()) {
                builder.add((Object)ExpressionTreeRewriter.this.rewrite(expression, context.get()));
            }
            if (!ExpressionTreeRewriter.sameElements(node.getValues(), (Iterable)builder.build())) {
                return new InListExpression((List<Expression>)builder.build());
            }
            return node;
        }

        @Override
        protected Expression visitExists(ExistsPredicate node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteExists(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return node;
        }

        @Override
        public Expression visitSubqueryExpression(SubqueryExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteSubqueryExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return node;
        }

        @Override
        public Expression visitLiteral(Literal node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteLiteral(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return node;
        }

        @Override
        public Expression visitQualifiedNameReference(QualifiedNameReference node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteQualifiedNameReference(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return node;
        }

        @Override
        public Expression visitDereferenceExpression(DereferenceExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteDereferenceExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression base = ExpressionTreeRewriter.this.rewrite(node.getBase(), context.get());
            if (base != node.getBase()) {
                return new DereferenceExpression(base, node.getFieldName());
            }
            return node;
        }

        @Override
        protected Expression visitExtract(Extract node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteExtract(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression expression = ExpressionTreeRewriter.this.rewrite(node.getExpression(), context.get());
            if (node.getExpression() != expression) {
                return new Extract(expression, node.getField());
            }
            return node;
        }

        @Override
        public Expression visitCast(Cast node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteCast(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression expression = ExpressionTreeRewriter.this.rewrite(node.getExpression(), context.get());
            if (node.getExpression() != expression) {
                return new Cast(expression, node.getType(), node.isSafe(), node.isTypeOnly());
            }
            return node;
        }

        @Override
        protected Expression visitFieldReference(FieldReference node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteFieldReference(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return node;
        }

        @Override
        protected Expression visitSymbolReference(SymbolReference node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteSymbolReference(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return node;
        }
    }
}

