/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.common.base.MoreObjects;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.DDLStatement;
import io.confluent.ksql.parser.tree.NodeLocation;
import io.confluent.ksql.parser.tree.QualifiedName;
import io.confluent.ksql.parser.tree.Statement;
import java.util.Objects;
import java.util.Optional;

public class DropTopic
extends Statement
implements DDLStatement {
    private final QualifiedName topicName;
    private final boolean exists;

    public DropTopic(QualifiedName tableName, boolean exists) {
        this(Optional.empty(), tableName, exists);
    }

    public DropTopic(NodeLocation location, QualifiedName tableName, boolean exists) {
        this(Optional.of(location), tableName, exists);
    }

    private DropTopic(Optional<NodeLocation> location, QualifiedName topicName, boolean exists) {
        super(location);
        this.topicName = topicName;
        this.exists = exists;
    }

    public QualifiedName getTopicName() {
        return this.topicName;
    }

    public boolean isExists() {
        return this.exists;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDropTopic(this, context);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.topicName, this.exists);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DropTopic o = (DropTopic)obj;
        return Objects.equals(this.topicName, o.topicName) && this.exists == o.exists;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("topicName", (Object)this.topicName).add("exists", this.exists).toString();
    }
}

