/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.common.base.MoreObjects;
import io.confluent.ksql.parser.tree.AbstractStreamDropStatement;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.DDLStatement;
import io.confluent.ksql.parser.tree.NodeLocation;
import io.confluent.ksql.parser.tree.QualifiedName;
import java.util.Objects;
import java.util.Optional;

public class DropStream
extends AbstractStreamDropStatement
implements DDLStatement {
    private final QualifiedName streamName;
    private final boolean exists;

    public DropStream(QualifiedName tableName, boolean exists) {
        this(Optional.empty(), tableName, exists);
    }

    public DropStream(NodeLocation location, QualifiedName tableName, boolean exists) {
        this(Optional.of(location), tableName, exists);
    }

    private DropStream(Optional<NodeLocation> location, QualifiedName streamName, boolean exists) {
        super(location);
        this.streamName = streamName;
        this.exists = exists;
    }

    @Override
    public QualifiedName getName() {
        return this.streamName;
    }

    public boolean isExists() {
        return this.exists;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDropStream(this, context);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.streamName, this.exists);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DropStream o = (DropStream)obj;
        return Objects.equals(this.streamName, o.streamName) && this.exists == o.exists;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableName", (Object)this.streamName).add("exists", this.exists).toString();
    }
}

