/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.common.base.MoreObjects;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.Expression;
import io.confluent.ksql.parser.tree.NodeLocation;
import io.confluent.ksql.parser.tree.Statement;
import io.confluent.ksql.parser.tree.Table;
import java.util.Objects;
import java.util.Optional;

public class Delete
extends Statement {
    private final Table table;
    private final Optional<Expression> where;

    public Delete(Table table, Optional<Expression> where) {
        this(Optional.empty(), table, where);
    }

    public Delete(NodeLocation location, Table table, Optional<Expression> where) {
        this(Optional.of(location), table, where);
    }

    private Delete(Optional<NodeLocation> location, Table table, Optional<Expression> where) {
        super(location);
        this.table = Objects.requireNonNull(table, "table is null");
        this.where = Objects.requireNonNull(where, "where is null");
    }

    public Table getTable() {
        return this.table;
    }

    public Optional<Expression> getWhere() {
        return this.where;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDelete(this, context);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.table, this.where);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Delete o = (Delete)obj;
        return Objects.equals(this.table, o.table) && Objects.equals(this.where, o.where);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("table", (Object)this.table.getName()).add("where", this.where).toString();
    }
}

