/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import io.confluent.ksql.parser.tree.AliasedRelation;
import io.confluent.ksql.parser.tree.ArithmeticBinaryExpression;
import io.confluent.ksql.parser.tree.ArithmeticUnaryExpression;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.BetweenPredicate;
import io.confluent.ksql.parser.tree.Cast;
import io.confluent.ksql.parser.tree.ComparisonExpression;
import io.confluent.ksql.parser.tree.CreateTableAsSelect;
import io.confluent.ksql.parser.tree.Delete;
import io.confluent.ksql.parser.tree.DereferenceExpression;
import io.confluent.ksql.parser.tree.Expression;
import io.confluent.ksql.parser.tree.Extract;
import io.confluent.ksql.parser.tree.FrameBound;
import io.confluent.ksql.parser.tree.FunctionCall;
import io.confluent.ksql.parser.tree.GroupBy;
import io.confluent.ksql.parser.tree.GroupingElement;
import io.confluent.ksql.parser.tree.InListExpression;
import io.confluent.ksql.parser.tree.InPredicate;
import io.confluent.ksql.parser.tree.IsNotNullPredicate;
import io.confluent.ksql.parser.tree.IsNullPredicate;
import io.confluent.ksql.parser.tree.Join;
import io.confluent.ksql.parser.tree.JoinOn;
import io.confluent.ksql.parser.tree.LikePredicate;
import io.confluent.ksql.parser.tree.LogicalBinaryExpression;
import io.confluent.ksql.parser.tree.Node;
import io.confluent.ksql.parser.tree.NotExpression;
import io.confluent.ksql.parser.tree.NullIfExpression;
import io.confluent.ksql.parser.tree.Query;
import io.confluent.ksql.parser.tree.QuerySpecification;
import io.confluent.ksql.parser.tree.Relation;
import io.confluent.ksql.parser.tree.Row;
import io.confluent.ksql.parser.tree.SampledRelation;
import io.confluent.ksql.parser.tree.SearchedCaseExpression;
import io.confluent.ksql.parser.tree.Select;
import io.confluent.ksql.parser.tree.SelectItem;
import io.confluent.ksql.parser.tree.SetOperation;
import io.confluent.ksql.parser.tree.SimpleCaseExpression;
import io.confluent.ksql.parser.tree.SimpleGroupBy;
import io.confluent.ksql.parser.tree.SingleColumn;
import io.confluent.ksql.parser.tree.SubqueryExpression;
import io.confluent.ksql.parser.tree.SubscriptExpression;
import io.confluent.ksql.parser.tree.TableSubquery;
import io.confluent.ksql.parser.tree.Values;
import io.confluent.ksql.parser.tree.WhenClause;
import io.confluent.ksql.parser.tree.Window;
import io.confluent.ksql.parser.tree.WindowFrame;
import io.confluent.ksql.parser.tree.WithQuery;
import java.util.Set;

public abstract class DefaultTraversalVisitor<R, C>
extends AstVisitor<R, C> {
    @Override
    protected R visitExtract(Extract node, C context) {
        return this.process(node.getExpression(), context);
    }

    @Override
    protected R visitCast(Cast node, C context) {
        return this.process(node.getExpression(), context);
    }

    @Override
    protected R visitArithmeticBinary(ArithmeticBinaryExpression node, C context) {
        this.process(node.getLeft(), context);
        this.process(node.getRight(), context);
        return null;
    }

    @Override
    protected R visitBetweenPredicate(BetweenPredicate node, C context) {
        this.process(node.getValue(), context);
        this.process(node.getMin(), context);
        this.process(node.getMax(), context);
        return null;
    }

    @Override
    protected R visitSubscriptExpression(SubscriptExpression node, C context) {
        this.process(node.getBase(), context);
        this.process(node.getIndex(), context);
        return null;
    }

    @Override
    protected R visitComparisonExpression(ComparisonExpression node, C context) {
        this.process(node.getLeft(), context);
        this.process(node.getRight(), context);
        return null;
    }

    @Override
    protected R visitQuery(Query node, C context) {
        this.process(node.getQueryBody(), context);
        return null;
    }

    @Override
    protected R visitWithQuery(WithQuery node, C context) {
        return this.process(node.getQuery(), context);
    }

    @Override
    protected R visitSelect(Select node, C context) {
        for (SelectItem item : node.getSelectItems()) {
            this.process(item, context);
        }
        return null;
    }

    @Override
    protected R visitSingleColumn(SingleColumn node, C context) {
        this.process(node.getExpression(), context);
        return null;
    }

    @Override
    protected R visitWhenClause(WhenClause node, C context) {
        this.process(node.getOperand(), context);
        this.process(node.getResult(), context);
        return null;
    }

    @Override
    protected R visitInPredicate(InPredicate node, C context) {
        this.process(node.getValue(), context);
        this.process(node.getValueList(), context);
        return null;
    }

    @Override
    protected R visitFunctionCall(FunctionCall node, C context) {
        for (Expression argument : node.getArguments()) {
            this.process(argument, context);
        }
        if (node.getWindow().isPresent()) {
            this.process(node.getWindow().get(), context);
        }
        return null;
    }

    @Override
    protected R visitDereferenceExpression(DereferenceExpression node, C context) {
        this.process(node.getBase(), context);
        return null;
    }

    @Override
    public R visitWindow(Window node, C context) {
        this.process(node.getWindowExpression(), context);
        return null;
    }

    @Override
    public R visitWindowFrame(WindowFrame node, C context) {
        this.process(node.getStart(), context);
        if (node.getEnd().isPresent()) {
            this.process(node.getEnd().get(), context);
        }
        return null;
    }

    @Override
    public R visitFrameBound(FrameBound node, C context) {
        if (node.getValue().isPresent()) {
            this.process(node.getValue().get(), context);
        }
        return null;
    }

    @Override
    protected R visitSimpleCaseExpression(SimpleCaseExpression node, C context) {
        this.process(node.getOperand(), context);
        for (WhenClause clause : node.getWhenClauses()) {
            this.process(clause, context);
        }
        node.getDefaultValue().ifPresent(value -> this.process((Node)value, context));
        return null;
    }

    @Override
    protected R visitInListExpression(InListExpression node, C context) {
        for (Expression value : node.getValues()) {
            this.process(value, context);
        }
        return null;
    }

    @Override
    protected R visitNullIfExpression(NullIfExpression node, C context) {
        this.process(node.getFirst(), context);
        this.process(node.getSecond(), context);
        return null;
    }

    @Override
    protected R visitArithmeticUnary(ArithmeticUnaryExpression node, C context) {
        return this.process(node.getValue(), context);
    }

    @Override
    protected R visitNotExpression(NotExpression node, C context) {
        return this.process(node.getValue(), context);
    }

    @Override
    protected R visitSearchedCaseExpression(SearchedCaseExpression node, C context) {
        for (WhenClause clause : node.getWhenClauses()) {
            this.process(clause, context);
        }
        node.getDefaultValue().ifPresent(value -> this.process((Node)value, context));
        return null;
    }

    @Override
    protected R visitLikePredicate(LikePredicate node, C context) {
        this.process(node.getValue(), context);
        this.process(node.getPattern(), context);
        if (node.getEscape() != null) {
            this.process(node.getEscape(), context);
        }
        return null;
    }

    @Override
    protected R visitIsNotNullPredicate(IsNotNullPredicate node, C context) {
        return this.process(node.getValue(), context);
    }

    @Override
    protected R visitIsNullPredicate(IsNullPredicate node, C context) {
        return this.process(node.getValue(), context);
    }

    @Override
    protected R visitLogicalBinaryExpression(LogicalBinaryExpression node, C context) {
        this.process(node.getLeft(), context);
        this.process(node.getRight(), context);
        return null;
    }

    @Override
    protected R visitSubqueryExpression(SubqueryExpression node, C context) {
        return this.process(node.getQuery(), context);
    }

    @Override
    protected R visitQuerySpecification(QuerySpecification node, C context) {
        this.process(node.getSelect(), context);
        this.process(node.getFrom(), context);
        if (node.getWhere().isPresent()) {
            this.process(node.getWhere().get(), context);
        }
        if (node.getGroupBy().isPresent()) {
            this.process(node.getGroupBy().get(), context);
        }
        if (node.getHaving().isPresent()) {
            this.process(node.getHaving().get(), context);
        }
        return null;
    }

    @Override
    protected R visitSetOperation(SetOperation node, C context) {
        for (Relation relation : node.getRelations()) {
            this.process(relation, context);
        }
        return null;
    }

    @Override
    protected R visitValues(Values node, C context) {
        for (Expression row : node.getRows()) {
            this.process(row, context);
        }
        return null;
    }

    @Override
    protected R visitRow(Row node, C context) {
        for (Expression expression : node.getItems()) {
            this.process(expression, context);
        }
        return null;
    }

    @Override
    protected R visitTableSubquery(TableSubquery node, C context) {
        return this.process(node.getQuery(), context);
    }

    @Override
    protected R visitAliasedRelation(AliasedRelation node, C context) {
        return this.process(node.getRelation(), context);
    }

    @Override
    protected R visitSampledRelation(SampledRelation node, C context) {
        this.process(node.getRelation(), context);
        this.process(node.getSamplePercentage(), context);
        if (node.getColumnsToStratifyOn().isPresent()) {
            for (Expression expression : node.getColumnsToStratifyOn().get()) {
                this.process(expression, context);
            }
        }
        return null;
    }

    @Override
    protected R visitJoin(Join node, C context) {
        this.process(node.getLeft(), context);
        this.process(node.getRight(), context);
        node.getCriteria().filter(criteria -> criteria instanceof JoinOn).map(criteria -> this.process(((JoinOn)criteria).getExpression(), context));
        return null;
    }

    @Override
    protected R visitGroupBy(GroupBy node, C context) {
        for (GroupingElement groupingElement : node.getGroupingElements()) {
            this.process(groupingElement, context);
        }
        return null;
    }

    @Override
    protected R visitGroupingElement(GroupingElement node, C context) {
        for (Set<Expression> expressions : node.enumerateGroupingSets()) {
            for (Expression expression : expressions) {
                this.process(expression, context);
            }
        }
        return null;
    }

    @Override
    protected R visitSimpleGroupBy(SimpleGroupBy node, C context) {
        this.visitGroupingElement(node, context);
        for (Expression expression : node.getColumnExpressions()) {
            this.process(expression, context);
        }
        return null;
    }

    @Override
    protected R visitDelete(Delete node, C context) {
        this.process(node.getTable(), context);
        node.getWhere().ifPresent(where -> this.process((Node)where, context));
        return null;
    }

    @Override
    protected R visitCreateTableAsSelect(CreateTableAsSelect node, C context) {
        this.process(node.getQuery(), context);
        node.getProperties().values().forEach(expression -> this.process((Node)expression, context));
        return null;
    }
}

