/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.NodeLocation;
import io.confluent.ksql.parser.tree.QualifiedName;
import io.confluent.ksql.parser.tree.SelectItem;
import java.util.Objects;
import java.util.Optional;

public class AllColumns
extends SelectItem {
    private final Optional<QualifiedName> prefix;

    public AllColumns(NodeLocation location) {
        super(Optional.of(location));
        this.prefix = Optional.empty();
    }

    public AllColumns(NodeLocation location, QualifiedName prefix) {
        this(Optional.of(location), prefix);
    }

    private AllColumns(Optional<NodeLocation> location, QualifiedName prefix) {
        super(location);
        Objects.requireNonNull(prefix, "prefix is null");
        this.prefix = Optional.of(prefix);
    }

    public Optional<QualifiedName> getPrefix() {
        return this.prefix;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitAllColumns(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AllColumns that = (AllColumns)o;
        return Objects.equals(this.prefix, that.prefix);
    }

    @Override
    public int hashCode() {
        return this.prefix.hashCode();
    }

    @Override
    public String toString() {
        return this.prefix.map(qualifiedName -> qualifiedName + ".*").orElse("*");
    }
}

