/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import io.confluent.ksql.parser.ExpressionFormatter;
import io.confluent.ksql.parser.tree.AliasedRelation;
import io.confluent.ksql.parser.tree.AllColumns;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.CreateStream;
import io.confluent.ksql.parser.tree.CreateStreamAsSelect;
import io.confluent.ksql.parser.tree.CreateTable;
import io.confluent.ksql.parser.tree.CreateTableAsSelect;
import io.confluent.ksql.parser.tree.CreateView;
import io.confluent.ksql.parser.tree.Delete;
import io.confluent.ksql.parser.tree.DropTable;
import io.confluent.ksql.parser.tree.DropView;
import io.confluent.ksql.parser.tree.Explain;
import io.confluent.ksql.parser.tree.ExplainFormat;
import io.confluent.ksql.parser.tree.ExplainOption;
import io.confluent.ksql.parser.tree.ExplainType;
import io.confluent.ksql.parser.tree.Expression;
import io.confluent.ksql.parser.tree.Join;
import io.confluent.ksql.parser.tree.JoinCriteria;
import io.confluent.ksql.parser.tree.JoinOn;
import io.confluent.ksql.parser.tree.JoinUsing;
import io.confluent.ksql.parser.tree.NaturalJoin;
import io.confluent.ksql.parser.tree.Node;
import io.confluent.ksql.parser.tree.QualifiedName;
import io.confluent.ksql.parser.tree.Query;
import io.confluent.ksql.parser.tree.QuerySpecification;
import io.confluent.ksql.parser.tree.Relation;
import io.confluent.ksql.parser.tree.RenameColumn;
import io.confluent.ksql.parser.tree.RenameTable;
import io.confluent.ksql.parser.tree.SampledRelation;
import io.confluent.ksql.parser.tree.Select;
import io.confluent.ksql.parser.tree.SelectItem;
import io.confluent.ksql.parser.tree.SetSession;
import io.confluent.ksql.parser.tree.ShowCatalogs;
import io.confluent.ksql.parser.tree.ShowColumns;
import io.confluent.ksql.parser.tree.ShowCreate;
import io.confluent.ksql.parser.tree.ShowFunctions;
import io.confluent.ksql.parser.tree.ShowPartitions;
import io.confluent.ksql.parser.tree.SingleColumn;
import io.confluent.ksql.parser.tree.Table;
import io.confluent.ksql.parser.tree.TableElement;
import io.confluent.ksql.parser.tree.TableSubquery;
import io.confluent.ksql.parser.tree.Values;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class SqlFormatter {
    private static final String INDENT = "   ";
    private static final Pattern NAME_PATTERN = Pattern.compile("[a-z_][a-z0-9_]*");

    private SqlFormatter() {
    }

    public static String formatSql(Node root) {
        StringBuilder builder = new StringBuilder();
        new Formatter(builder, true).process(root, 0);
        return builder.toString();
    }

    public static String formatSql(Node root, boolean unmangleNames) {
        StringBuilder builder = new StringBuilder();
        new Formatter(builder, unmangleNames).process(root, 0);
        return builder.toString();
    }

    private static void appendAliasColumns(StringBuilder builder, List<String> columns) {
        if (columns != null && !columns.isEmpty()) {
            builder.append(" (");
            Joiner.on((String)", ").appendTo(builder, columns);
            builder.append(')');
        }
    }

    private static class Formatter
    extends AstVisitor<Void, Integer> {
        private final StringBuilder builder;
        private final boolean unmangledNames;

        public Formatter(StringBuilder builder, boolean unmangleNames) {
            this.builder = builder;
            this.unmangledNames = unmangleNames;
        }

        @Override
        protected Void visitNode(Node node, Integer indent) {
            throw new UnsupportedOperationException("not yet implemented: " + node);
        }

        @Override
        protected Void visitExpression(Expression node, Integer indent) {
            Preconditions.checkArgument((indent == 0 ? 1 : 0) != 0, (Object)"visitExpression should only be called at root");
            this.builder.append(ExpressionFormatter.formatExpression(node, this.unmangledNames));
            return null;
        }

        @Override
        protected Void visitQuery(Query node, Integer indent) {
            this.processRelation(node.getQueryBody(), indent);
            if (node.getLimit().isPresent()) {
                this.append(indent, "LIMIT " + node.getLimit().get()).append('\n');
            }
            return null;
        }

        @Override
        protected Void visitQuerySpecification(QuerySpecification node, Integer indent) {
            this.process(node.getSelect(), indent);
            this.append(indent, "FROM");
            this.builder.append('\n');
            this.append(indent, "  ");
            this.builder.append('\n');
            if (node.getWhere().isPresent()) {
                this.append(indent, "WHERE " + ExpressionFormatter.formatExpression(node.getWhere().get())).append('\n');
            }
            if (node.getGroupBy().isPresent()) {
                this.append(indent, "GROUP BY " + (node.getGroupBy().get().isDistinct() ? " DISTINCT " : "") + ExpressionFormatter.formatGroupBy(node.getGroupBy().get().getGroupingElements())).append('\n');
            }
            if (node.getHaving().isPresent()) {
                this.append(indent, "HAVING " + ExpressionFormatter.formatExpression(node.getHaving().get())).append('\n');
            }
            if (node.getLimit().isPresent()) {
                this.append(indent, "LIMIT " + node.getLimit().get()).append('\n');
            }
            return null;
        }

        @Override
        protected Void visitSelect(Select node, Integer indent) {
            this.append(indent, "SELECT");
            if (node.isDistinct()) {
                this.builder.append(" DISTINCT");
            }
            if (node.getSelectItems().size() > 1) {
                boolean first = true;
                for (SelectItem item : node.getSelectItems()) {
                    this.builder.append("\n").append(Formatter.indentString(indent)).append(first ? "  " : ", ");
                    this.process(item, indent);
                    first = false;
                }
            } else {
                this.builder.append(' ');
                this.process((Node)Iterables.getOnlyElement(node.getSelectItems()), indent);
            }
            this.builder.append('\n');
            return null;
        }

        @Override
        protected Void visitSingleColumn(SingleColumn node, Integer indent) {
            this.builder.append(ExpressionFormatter.formatExpression(node.getExpression()));
            if (node.getAlias().isPresent()) {
                this.builder.append(' ').append('\"').append(node.getAlias().get()).append('\"');
            }
            return null;
        }

        @Override
        protected Void visitAllColumns(AllColumns node, Integer context) {
            this.builder.append(node.toString());
            return null;
        }

        @Override
        protected Void visitTable(Table node, Integer indent) {
            this.builder.append(node.getName().toString());
            return null;
        }

        @Override
        protected Void visitJoin(Join node, Integer indent) {
            JoinCriteria criteria = node.getCriteria().orElse(null);
            String type = node.getType().toString();
            if (criteria instanceof NaturalJoin) {
                type = "NATURAL " + type;
            }
            if (node.getType() != Join.Type.IMPLICIT) {
                this.builder.append('(');
            }
            this.process(node.getLeft(), indent);
            this.builder.append('\n');
            if (node.getType() == Join.Type.IMPLICIT) {
                this.append(indent, ", ");
            } else {
                this.append(indent, type).append(" JOIN ");
            }
            this.process(node.getRight(), indent);
            if (node.getType() != Join.Type.CROSS && node.getType() != Join.Type.IMPLICIT) {
                if (criteria instanceof JoinUsing) {
                    JoinUsing using = (JoinUsing)criteria;
                    this.builder.append(" USING (").append(Joiner.on((String)", ").join(using.getColumns())).append(")");
                } else if (criteria instanceof JoinOn) {
                    JoinOn on = (JoinOn)criteria;
                    this.builder.append(" ON (").append(ExpressionFormatter.formatExpression(on.getExpression())).append(")");
                } else if (!(criteria instanceof NaturalJoin)) {
                    throw new UnsupportedOperationException("unknown join criteria: " + criteria);
                }
            }
            if (node.getType() != Join.Type.IMPLICIT) {
                this.builder.append(")");
            }
            return null;
        }

        @Override
        protected Void visitAliasedRelation(AliasedRelation node, Integer indent) {
            this.process(node.getRelation(), indent);
            this.builder.append(' ').append(node.getAlias());
            SqlFormatter.appendAliasColumns(this.builder, node.getColumnNames());
            return null;
        }

        @Override
        protected Void visitSampledRelation(SampledRelation node, Integer indent) {
            this.process(node.getRelation(), indent);
            this.builder.append(" TABLESAMPLE ").append((Object)node.getType()).append(" (").append(node.getSamplePercentage()).append(')');
            if (node.getColumnsToStratifyOn().isPresent()) {
                this.builder.append(" STRATIFY ON ").append(" (").append(Joiner.on((String)",").join((Iterable)node.getColumnsToStratifyOn().get()));
                this.builder.append(')');
            }
            return null;
        }

        @Override
        protected Void visitValues(Values node, Integer indent) {
            this.builder.append(" VALUES ");
            boolean first = true;
            for (Expression row : node.getRows()) {
                this.builder.append("\n").append(Formatter.indentString(indent)).append(first ? "  " : ", ");
                this.builder.append(ExpressionFormatter.formatExpression(row));
                first = false;
            }
            this.builder.append('\n');
            return null;
        }

        @Override
        protected Void visitTableSubquery(TableSubquery node, Integer indent) {
            this.builder.append('(').append('\n');
            this.process(node.getQuery(), indent + 1);
            this.append(indent, ") ");
            return null;
        }

        @Override
        protected Void visitCreateStream(CreateStream node, Integer indent) {
            this.builder.append("CREATE STREAM ");
            if (node.isNotExists()) {
                this.builder.append("IF NOT EXISTS ");
            }
            this.builder.append(node.getName()).append(" \n");
            if (!node.getElements().isEmpty()) {
                this.builder.append("(");
                boolean addComma = false;
                for (TableElement tableElement : node.getElements()) {
                    if (addComma) {
                        this.builder.append(", ");
                    } else {
                        addComma = true;
                    }
                    this.builder.append(tableElement.getName()).append(" ").append(tableElement.getType());
                }
                this.builder.append(")").append(" WITH (");
                addComma = false;
                for (Map.Entry entry : node.getProperties().entrySet()) {
                    if (addComma) {
                        this.builder.append(", ");
                    } else {
                        addComma = true;
                    }
                    this.builder.append(entry.getKey().toString()).append("=").append(entry.getValue().toString());
                }
                this.builder.append(");");
            }
            return null;
        }

        @Override
        protected Void visitCreateTable(CreateTable node, Integer indent) {
            this.builder.append("CREATE TABLE ");
            if (node.isNotExists()) {
                this.builder.append("IF NOT EXISTS ");
            }
            this.builder.append(node.getName()).append(" ");
            if (!node.getElements().isEmpty()) {
                this.builder.append("(");
                boolean addComma = false;
                for (TableElement tableElement : node.getElements()) {
                    if (addComma) {
                        this.builder.append(", ");
                    } else {
                        addComma = true;
                    }
                    this.builder.append(tableElement.getName()).append(" ").append(tableElement.getType());
                }
                this.builder.append(")").append(" WITH (");
                addComma = false;
                for (Map.Entry entry : node.getProperties().entrySet()) {
                    if (addComma) {
                        this.builder.append(", ");
                    } else {
                        addComma = true;
                    }
                    this.builder.append(entry.getKey().toString()).append("=").append(entry.getValue().toString());
                }
                this.builder.append(");");
            }
            return null;
        }

        @Override
        protected Void visitCreateView(CreateView node, Integer indent) {
            this.builder.append("CREATE ");
            if (node.isReplace()) {
                this.builder.append("OR REPLACE ");
            }
            this.builder.append("VIEW ").append(node.getName()).append(" AS\n");
            this.process(node.getQuery(), indent);
            return null;
        }

        @Override
        protected Void visitDropView(DropView node, Integer context) {
            this.builder.append("DROP VIEW ");
            if (node.isExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(node.getName());
            return null;
        }

        @Override
        protected Void visitExplain(Explain node, Integer indent) {
            this.builder.append("EXPLAIN ");
            if (node.isAnalyze()) {
                this.builder.append("ANALYZE ");
            }
            ArrayList<String> options = new ArrayList<String>();
            for (ExplainOption option : node.getOptions()) {
                if (option instanceof ExplainType) {
                    options.add("TYPE " + (Object)((Object)((ExplainType)option).getType()));
                    continue;
                }
                if (option instanceof ExplainFormat) {
                    options.add("FORMAT " + (Object)((Object)((ExplainFormat)option).getType()));
                    continue;
                }
                throw new UnsupportedOperationException("unhandled explain option: " + option);
            }
            if (!options.isEmpty()) {
                this.builder.append("(");
                Joiner.on((String)", ").appendTo(this.builder, options);
                this.builder.append(")");
            }
            this.builder.append("\n");
            this.process(node.getStatement(), indent);
            return null;
        }

        @Override
        protected Void visitShowCatalogs(ShowCatalogs node, Integer context) {
            this.builder.append("SHOW CATALOGS");
            node.getLikePattern().ifPresent(value -> this.builder.append(" LIKE ").append(ExpressionFormatter.formatStringLiteral(value)));
            return null;
        }

        @Override
        protected Void visitShowCreate(ShowCreate node, Integer context) {
            if (node.getType() == ShowCreate.Type.TABLE) {
                this.builder.append("SHOW CREATE TABLE ").append(Formatter.formatName(node.getName()));
            } else if (node.getType() == ShowCreate.Type.VIEW) {
                this.builder.append("SHOW CREATE VIEW ").append(Formatter.formatName(node.getName()));
            }
            return null;
        }

        @Override
        protected Void visitShowColumns(ShowColumns node, Integer context) {
            this.builder.append("SHOW COLUMNS FROM ").append(node.getTable());
            return null;
        }

        @Override
        protected Void visitShowPartitions(ShowPartitions node, Integer context) {
            this.builder.append("SHOW PARTITIONS FROM ").append(node.getTable());
            if (node.getWhere().isPresent()) {
                this.builder.append(" WHERE ").append(ExpressionFormatter.formatExpression(node.getWhere().get()));
            }
            if (node.getLimit().isPresent()) {
                this.builder.append(" LIMIT ").append(node.getLimit().get());
            }
            return null;
        }

        @Override
        protected Void visitShowFunctions(ShowFunctions node, Integer context) {
            this.builder.append("SHOW FUNCTIONS");
            return null;
        }

        @Override
        protected Void visitDelete(Delete node, Integer context) {
            this.builder.append("DELETE FROM ").append(node.getTable().getName());
            if (node.getWhere().isPresent()) {
                this.builder.append(" WHERE ").append(ExpressionFormatter.formatExpression(node.getWhere().get()));
            }
            return null;
        }

        @Override
        protected Void visitCreateStreamAsSelect(CreateStreamAsSelect node, Integer indent) {
            this.builder.append("CREATE STREAM ");
            if (node.isNotExists()) {
                this.builder.append("IF NOT EXISTS ");
            }
            this.builder.append(node.getName());
            if (!node.getProperties().isEmpty()) {
                this.builder.append(" WITH (");
                Joiner.on((String)", ").appendTo(this.builder, Iterables.transform(node.getProperties().entrySet(), entry -> (String)entry.getKey() + " = " + ExpressionFormatter.formatExpression((Expression)entry.getValue())));
                this.builder.append(")");
            }
            this.builder.append(" AS ");
            this.process(node.getQuery(), indent);
            return null;
        }

        @Override
        protected Void visitCreateTableAsSelect(CreateTableAsSelect node, Integer indent) {
            this.builder.append("CREATE TABLE ");
            if (node.isNotExists()) {
                this.builder.append("IF NOT EXISTS ");
            }
            this.builder.append(node.getName());
            if (!node.getProperties().isEmpty()) {
                this.builder.append(" WITH (");
                Joiner.on((String)", ").appendTo(this.builder, Iterables.transform(node.getProperties().entrySet(), entry -> (String)entry.getKey() + " = " + ExpressionFormatter.formatExpression((Expression)entry.getValue())));
                this.builder.append(")");
            }
            this.builder.append(" AS ");
            this.process(node.getQuery(), indent);
            return null;
        }

        private static String formatName(String name) {
            if (NAME_PATTERN.matcher(name).matches()) {
                return name;
            }
            return "\"" + name + "\"";
        }

        private static String formatName(QualifiedName name) {
            return name.getParts().stream().map(Formatter::formatName).collect(Collectors.joining("."));
        }

        @Override
        protected Void visitDropTable(DropTable node, Integer context) {
            this.builder.append("DROP TABLE ");
            if (node.isExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(node.getName());
            return null;
        }

        @Override
        protected Void visitRenameTable(RenameTable node, Integer context) {
            this.builder.append("ALTER TABLE ").append(node.getSource()).append(" RENAME TO ").append(node.getTarget());
            return null;
        }

        @Override
        protected Void visitRenameColumn(RenameColumn node, Integer context) {
            this.builder.append("ALTER TABLE ").append(node.getTable()).append(" RENAME COLUMN ").append(node.getSource()).append(" TO ").append(node.getTarget());
            return null;
        }

        @Override
        public Void visitSetSession(SetSession node, Integer context) {
            this.builder.append("SET SESSION ").append(node.getName()).append(" = ").append(ExpressionFormatter.formatExpression(node.getValue()));
            return null;
        }

        private void processRelation(Relation relation, Integer indent) {
            if (relation instanceof Table) {
                this.builder.append("TABLE ").append(((Table)relation).getName()).append('\n');
            } else {
                this.process(relation, indent);
            }
        }

        private StringBuilder append(int indent, String value) {
            return this.builder.append(Formatter.indentString(indent)).append(value);
        }

        private static String indentString(int indent) {
            return Strings.repeat((String)SqlFormatter.INDENT, (int)indent);
        }
    }
}

