/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser;

import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.parser.AstBuilder;
import io.confluent.ksql.parser.CaseInsensitiveStream;
import io.confluent.ksql.parser.ParsingException;
import io.confluent.ksql.parser.SqlBaseLexer;
import io.confluent.ksql.parser.SqlBaseParser;
import io.confluent.ksql.parser.exception.ParseFailedException;
import io.confluent.ksql.parser.tree.Node;
import io.confluent.ksql.parser.tree.Statement;
import io.confluent.ksql.util.DataSourceExtractor;
import io.confluent.ksql.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;

public class KsqlParser {
    private static final BaseErrorListener ERROR_LISTENER = new BaseErrorListener(){

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String message, RecognitionException e) {
            throw new ParsingException(message, e, line, charPositionInLine);
        }
    };

    public List<Statement> buildAst(String sql, MetaStore metaStore) {
        try {
            ParserRuleContext tree = this.getParseTree(sql);
            SqlBaseParser.StatementsContext statementsContext = (SqlBaseParser.StatementsContext)tree;
            ArrayList<Statement> astNodes = new ArrayList<Statement>();
            for (SqlBaseParser.SingleStatementContext statementContext : statementsContext.singleStatement()) {
                DataSourceExtractor dataSourceExtractor = new DataSourceExtractor(metaStore);
                dataSourceExtractor.extractDataSources((ParseTree)statementContext);
                Node root = (Node)new AstBuilder(dataSourceExtractor).visit((ParseTree)statementContext);
                Statement statement = (Statement)root;
                astNodes.add(statement);
            }
            return astNodes;
        }
        catch (Exception e) {
            throw new ParseFailedException(e.getMessage(), e);
        }
    }

    public List<SqlBaseParser.SingleStatementContext> getStatements(String sql) {
        try {
            ParserRuleContext tree = this.getParseTree(sql);
            SqlBaseParser.StatementsContext statementsContext = (SqlBaseParser.StatementsContext)tree;
            return statementsContext.singleStatement();
        }
        catch (Exception e) {
            throw new ParseFailedException(e.getMessage(), e);
        }
    }

    public Pair<Statement, DataSourceExtractor> prepareStatement(SqlBaseParser.SingleStatementContext statementContext, MetaStore metaStore) {
        DataSourceExtractor dataSourceExtractor = new DataSourceExtractor(metaStore);
        dataSourceExtractor.extractDataSources((ParseTree)statementContext);
        AstBuilder astBuilder = new AstBuilder(dataSourceExtractor);
        Node root = (Node)astBuilder.visit((ParseTree)statementContext);
        Statement statement = (Statement)root;
        return new Pair<Statement, DataSourceExtractor>(statement, dataSourceExtractor);
    }

    private ParserRuleContext getParseTree(String sql) {
        ParserRuleContext tree;
        SqlBaseLexer sqlBaseLexer = new SqlBaseLexer(new CaseInsensitiveStream((CharStream)new ANTLRInputStream(sql)));
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)sqlBaseLexer);
        SqlBaseParser sqlBaseParser = new SqlBaseParser((TokenStream)tokenStream);
        sqlBaseLexer.removeErrorListeners();
        sqlBaseLexer.addErrorListener((ANTLRErrorListener)ERROR_LISTENER);
        sqlBaseParser.removeErrorListeners();
        sqlBaseParser.addErrorListener((ANTLRErrorListener)ERROR_LISTENER);
        Function<SqlBaseParser, ParserRuleContext> parseFunction = SqlBaseParser::statements;
        try {
            ((ParserATNSimulator)sqlBaseParser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
            tree = parseFunction.apply(sqlBaseParser);
        }
        catch (ParseCancellationException ex) {
            tokenStream.reset();
            sqlBaseParser.reset();
            ((ParserATNSimulator)sqlBaseParser.getInterpreter()).setPredictionMode(PredictionMode.LL);
            tree = parseFunction.apply(sqlBaseParser);
        }
        return tree;
    }
}

