/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.metastore;

import io.confluent.ksql.metastore.KsqlTopic;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.serde.DataSource;
import io.confluent.ksql.util.KsqlException;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;

public abstract class StructuredDataSource
implements DataSource {
    final String dataSourceName;
    final DataSource.DataSourceType dataSourceType;
    final Schema schema;
    final Field keyField;
    final Field timestampField;
    final KsqlTopic ksqlTopic;
    final String sqlExpression;

    public StructuredDataSource(String sqlExpression, String datasourceName, Schema schema, Field keyField, Field timestampField, DataSource.DataSourceType dataSourceType, KsqlTopic ksqlTopic) {
        this.sqlExpression = sqlExpression;
        this.dataSourceName = datasourceName;
        this.schema = schema;
        this.keyField = keyField;
        this.timestampField = timestampField;
        this.dataSourceType = dataSourceType;
        this.ksqlTopic = ksqlTopic;
    }

    public static DataSource.DataSourceType getDataSourceType(String dataSourceTypeName) {
        switch (dataSourceTypeName) {
            case "STREAM": {
                return DataSource.DataSourceType.KSTREAM;
            }
            case "TABLE": {
                return DataSource.DataSourceType.KTABLE;
            }
        }
        throw new KsqlException("DataSource Type is not supported: " + dataSourceTypeName);
    }

    public String getName() {
        return this.dataSourceName;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public Field getKeyField() {
        return this.keyField;
    }

    public DataSource.DataSourceType getDataSourceType() {
        return this.dataSourceType;
    }

    public KsqlTopic getKsqlTopic() {
        return this.ksqlTopic;
    }

    public Field getTimestampField() {
        return this.timestampField;
    }

    public abstract StructuredDataSource cloneWithTimeKeyColumns();

    public abstract StructuredDataSource cloneWithTimeField(String var1);

    public String getTopicName() {
        return this.ksqlTopic.getTopicName();
    }

    public abstract QueryId getPersistentQueryId();

    public String getSqlExpression() {
        return this.sqlExpression;
    }
}

