/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import io.confluent.ksql.util.KsqlException;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;

public class SerDeUtil {
    public static org.apache.kafka.connect.data.Schema getSchemaFromAvro(String avroSchemaString) {
        Schema.Parser parser = new Schema.Parser();
        Schema avroSchema = parser.parse(avroSchemaString);
        SchemaBuilder inferredSchema = SchemaBuilder.struct().name(avroSchema.getName());
        for (Schema.Field avroField : avroSchema.getFields()) {
            inferredSchema.field(avroField.name(), SerDeUtil.getKSQLSchemaForAvroSchema(avroField.schema()));
        }
        return inferredSchema.build();
    }

    private static org.apache.kafka.connect.data.Schema getKSQLSchemaForAvroSchema(Schema avroSchema) {
        switch (avroSchema.getType()) {
            case INT: {
                return org.apache.kafka.connect.data.Schema.INT32_SCHEMA;
            }
            case LONG: {
                return org.apache.kafka.connect.data.Schema.INT64_SCHEMA;
            }
            case DOUBLE: 
            case FLOAT: {
                return org.apache.kafka.connect.data.Schema.FLOAT64_SCHEMA;
            }
            case BOOLEAN: {
                return org.apache.kafka.connect.data.Schema.BOOLEAN_SCHEMA;
            }
            case STRING: {
                return org.apache.kafka.connect.data.Schema.STRING_SCHEMA;
            }
            case ARRAY: {
                return SchemaBuilder.array((org.apache.kafka.connect.data.Schema)SerDeUtil.getKSQLSchemaForAvroSchema(avroSchema.getElementType()));
            }
            case MAP: {
                return SchemaBuilder.map((org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.STRING_SCHEMA, (org.apache.kafka.connect.data.Schema)SerDeUtil.getKSQLSchemaForAvroSchema(avroSchema.getValueType()));
            }
            case UNION: {
                List schemaList = avroSchema.getTypes();
                if (schemaList.size() == 1) {
                    return SerDeUtil.getKSQLSchemaForAvroSchema((Schema)schemaList.get(0));
                }
                if (schemaList.size() == 2) {
                    if (((Schema)schemaList.get(0)).getType() == Schema.Type.NULL) {
                        return SerDeUtil.getKSQLSchemaForAvroSchema((Schema)schemaList.get(1));
                    }
                    if (((Schema)schemaList.get(1)).getType() == Schema.Type.NULL) {
                        return SerDeUtil.getKSQLSchemaForAvroSchema((Schema)schemaList.get(0));
                    }
                }
                throw new KsqlException(String.format("Union type cannot have more than two types and one of them should be null.", new Object[0]));
            }
        }
        throw new KsqlException(String.format("Cannot find correct type for avro type: %s", avroSchema.getFullName()));
    }
}

