/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import io.confluent.ksql.planner.plan.OutputNode;
import io.confluent.ksql.serde.DataSource;
import io.confluent.ksql.util.KafkaTopicClient;
import java.util.Objects;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.Topology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryMetadata {
    private static final Logger log = LoggerFactory.getLogger(QueryMetadata.class);
    private final String statementString;
    private final KafkaStreams kafkaStreams;
    private final OutputNode outputNode;
    private final String executionPlan;
    private final DataSource.DataSourceType dataSourceType;
    private final String queryApplicationId;
    private final KafkaTopicClient kafkaTopicClient;
    private final Topology topoplogy;

    public QueryMetadata(String statementString, KafkaStreams kafkaStreams, OutputNode outputNode, String executionPlan, DataSource.DataSourceType dataSourceType, String queryApplicationId, KafkaTopicClient kafkaTopicClient, Topology topoplogy) {
        this.statementString = statementString;
        this.kafkaStreams = kafkaStreams;
        this.outputNode = outputNode;
        this.executionPlan = executionPlan;
        this.dataSourceType = dataSourceType;
        this.queryApplicationId = queryApplicationId;
        this.kafkaTopicClient = kafkaTopicClient;
        this.topoplogy = topoplogy;
    }

    public String getStatementString() {
        return this.statementString;
    }

    public KafkaStreams getKafkaStreams() {
        return this.kafkaStreams;
    }

    public OutputNode getOutputNode() {
        return this.outputNode;
    }

    public String getExecutionPlan() {
        return this.executionPlan;
    }

    public DataSource.DataSourceType getDataSourceType() {
        return this.dataSourceType;
    }

    public String getQueryApplicationId() {
        return this.queryApplicationId;
    }

    public Topology getTopology() {
        return this.topoplogy;
    }

    public void close() {
        this.kafkaStreams.close();
        if (this.kafkaStreams.state() == KafkaStreams.State.NOT_RUNNING) {
            this.kafkaStreams.cleanUp();
            this.kafkaTopicClient.deleteInternalTopics(this.queryApplicationId);
        } else {
            log.error("Could not clean up the query with application id: {}. Query status is: {}", (Object)this.queryApplicationId, (Object)this.kafkaStreams.state());
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof QueryMetadata)) {
            return false;
        }
        QueryMetadata that = (QueryMetadata)o;
        return Objects.equals(this.statementString, that.statementString) && Objects.equals(this.kafkaStreams, that.kafkaStreams) && Objects.equals(this.outputNode, that.outputNode) && Objects.equals(this.queryApplicationId, that.queryApplicationId);
    }

    public int hashCode() {
        return Objects.hash(this.statementString, this.kafkaStreams, this.outputNode, this.queryApplicationId);
    }

    public void start() {
        log.info("Starting query with application id: {}", (Object)this.queryApplicationId);
        this.kafkaStreams.start();
    }

    public String getTopologyDescription() {
        return this.topoplogy.describe().toString();
    }
}

