/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import com.mapr.fs.MapRFileAce;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.streams.mapr.Utils;

public class MaprFSUtils {
    public static void createAppDirAndInternalStreamsIfNotExist(KsqlConfig config) {
        try {
            FileSystem fs = FileSystem.get((Configuration)new Configuration());
            String currentUser = UserGroupInformation.getCurrentUser().getUserName();
            if (!Utils.maprFSpathExists((FileSystem)fs, (String)"/apps/ksql/")) {
                throw new KsqlException("/apps/ksql/ doesn't exist");
            }
            String errorMessage = String.format("User: %s has no permissions to run KSQL service with ID: %s", currentUser, config.getString("ksql.service.id"));
            if (!Utils.maprFSpathExists((FileSystem)fs, (String)config.getCommandsStreamFolder())) {
                ArrayList<MapRFileAce> aceList = new ArrayList<MapRFileAce>();
                MapRFileAce ace = new MapRFileAce(MapRFileAce.AccessType.READDIR);
                ace.setBooleanExpression("u:" + currentUser);
                aceList.add(ace);
                ace = new MapRFileAce(MapRFileAce.AccessType.ADDCHILD);
                ace.setBooleanExpression("u:" + currentUser);
                aceList.add(ace);
                ace = new MapRFileAce(MapRFileAce.AccessType.LOOKUPDIR);
                ace.setBooleanExpression("u:" + currentUser);
                aceList.add(ace);
                ace = new MapRFileAce(MapRFileAce.AccessType.DELETECHILD);
                ace.setBooleanExpression("u:" + currentUser);
                aceList.add(ace);
                Utils.maprFSpathCreate((FileSystem)fs, (String)config.getCommandsStreamFolder(), aceList, (String)currentUser, (String)errorMessage);
            } else {
                Utils.validateDirectoryPerms((FileSystem)fs, (String)config.getCommandsStreamFolder(), (String)currentUser, (String)errorMessage);
            }
            Utils.createStream((String)config.getCommandsStream());
        }
        catch (IOException e) {
            throw new KafkaException((Throwable)e);
        }
    }
}

