/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;

public interface KafkaConsumerGroupClient
extends AutoCloseable {
    public List<String> listGroups();

    public ConsumerGroupSummary describeConsumerGroup(String var1);

    @Override
    public void close();

    public static class ConsumerSummary {
        final List<TopicPartition> partitions = new ArrayList<TopicPartition>();
        private final String consumerId;

        public ConsumerSummary(String consumerId) {
            this.consumerId = consumerId;
        }

        public void addPartition(TopicPartition topicPartition) {
            this.partitions.add(topicPartition);
        }

        public String getConsumerId() {
            return this.consumerId;
        }

        public List<TopicPartition> partitions() {
            return this.partitions;
        }
    }

    public static class ConsumerGroupSummary {
        final Map<String, ConsumerSummary> consumerSummaries = new HashMap<String, ConsumerSummary>();

        public Collection<ConsumerSummary> consumers() {
            return this.consumerSummaries.values();
        }

        public void addConsumerSummary(ConsumerSummary consumerSummary) {
            this.consumerSummaries.put(consumerSummary.getConsumerId(), consumerSummary);
        }
    }
}

