/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Objects;

public class ArrayUtil {
    public static <T> int getNullIndex(T[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != null) continue;
            return i;
        }
        return -1;
    }

    public static <T> T[] getNoNullArray(Class<T> clazz, T[] array) {
        int nullIndex = ArrayUtil.getNullIndex(array);
        if (nullIndex == -1) {
            return array;
        }
        Object[] noNullArray = (Object[])Array.newInstance(clazz, nullIndex);
        for (int i = 0; i < noNullArray.length; ++i) {
            noNullArray[i] = array[i];
        }
        return noNullArray;
    }

    public static <T> T[] padWithNull(Class<T> clazz, T[] array, int finalLength) {
        int i;
        if (array.length >= finalLength) {
            return array;
        }
        Object[] paddedArray = (Object[])Array.newInstance(clazz, finalLength);
        for (i = 0; i < array.length; ++i) {
            paddedArray[i] = array[i];
        }
        for (i = array.length; i < finalLength; ++i) {
            paddedArray[i] = null;
        }
        return paddedArray;
    }

    public static <T> boolean containsValue(T value, T[] array) {
        return Arrays.stream(array).anyMatch(o -> Objects.equals(o, value));
    }
}

