/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.parser.tree.Expression;
import io.confluent.ksql.parser.tree.ExpressionRewriter;
import io.confluent.ksql.parser.tree.ExpressionTreeRewriter;
import io.confluent.ksql.parser.tree.FunctionCall;
import io.confluent.ksql.parser.tree.QualifiedName;
import io.confluent.ksql.parser.tree.QualifiedNameReference;
import java.util.ArrayList;

public class AggregateExpressionRewriter
extends ExpressionRewriter<Void> {
    public static final String AGGREGATE_FUNCTION_VARIABLE_PREFIX = "KSQL_AGG_VARIABLE_";
    private int aggVariableIndex = 0;
    private final FunctionRegistry functionRegistry;

    public AggregateExpressionRewriter(FunctionRegistry functionRegistry) {
        this.functionRegistry = functionRegistry;
    }

    public Expression rewriteFunctionCall(FunctionCall node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
        String functionName = node.getName().getSuffix();
        if (this.functionRegistry.isAnAggregateFunction(functionName)) {
            String aggVarName = AGGREGATE_FUNCTION_VARIABLE_PREFIX + this.aggVariableIndex;
            ++this.aggVariableIndex;
            return new QualifiedNameReference(QualifiedName.of((String)aggVarName));
        }
        ArrayList<Expression> arguments = new ArrayList<Expression>();
        for (Expression argExpression : node.getArguments()) {
            arguments.add(treeRewriter.rewrite(argExpression, (Object)context));
        }
        return new FunctionCall(node.getName(), arguments);
    }
}

