/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.structured;

import io.confluent.ksql.GenericRow;
import io.confluent.ksql.codegen.CodeGenRunner;
import io.confluent.ksql.codegen.SqlToJavaVisitor;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.function.udf.Kudf;
import io.confluent.ksql.parser.tree.Expression;
import io.confluent.ksql.util.ExpressionMetadata;
import io.confluent.ksql.util.GenericRowValueTypeEnforcer;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.SchemaUtil;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.streams.kstream.Predicate;
import org.codehaus.commons.compiler.CompilerFactoryFactory;
import org.codehaus.commons.compiler.IExpressionEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlPredicate {
    private Expression filterExpression;
    private final Schema schema;
    private IExpressionEvaluator ee;
    private int[] columnIndexes;
    private boolean isWindowedKey;
    private final FunctionRegistry functionRegistry;
    private GenericRowValueTypeEnforcer genericRowValueTypeEnforcer;
    private static final Logger log = LoggerFactory.getLogger(SqlPredicate.class);

    SqlPredicate(Expression filterExpression, Schema schema, boolean isWindowedKey, FunctionRegistry functionRegistry) {
        this.filterExpression = filterExpression;
        this.schema = schema;
        this.genericRowValueTypeEnforcer = new GenericRowValueTypeEnforcer(schema);
        this.isWindowedKey = isWindowedKey;
        this.functionRegistry = functionRegistry;
        CodeGenRunner codeGenRunner = new CodeGenRunner(schema, functionRegistry);
        Map<String, Class> parameterMap = codeGenRunner.getParameterInfo(filterExpression);
        String[] parameterNames = new String[parameterMap.size()];
        Class[] parameterTypes = new Class[parameterMap.size()];
        this.columnIndexes = new int[parameterMap.size()];
        int index = 0;
        for (Map.Entry<String, Class> entry : parameterMap.entrySet()) {
            parameterNames[index] = entry.getKey();
            parameterTypes[index] = entry.getValue();
            this.columnIndexes[index] = SchemaUtil.getFieldIndexByName((Schema)schema, (String)entry.getKey());
            ++index;
        }
        try {
            this.ee = CompilerFactoryFactory.getDefaultCompilerFactory().newExpressionEvaluator();
            this.ee.setParameters(parameterNames, parameterTypes);
            this.ee.setExpressionType(Boolean.TYPE);
            String expressionStr = new SqlToJavaVisitor(schema, functionRegistry).process(filterExpression);
            this.ee.cook(expressionStr);
        }
        catch (Exception e) {
            throw new KsqlException("Failed to generate code for SqlPredicate.filterExpression: " + filterExpression + "schema:" + schema + "isWindowedKey:" + isWindowedKey, (Throwable)e);
        }
    }

    Predicate getPredicate() {
        if (this.isWindowedKey) {
            return this.getWindowedKeyPredicate();
        }
        return this.getStringKeyPredicate();
    }

    private Predicate<String, GenericRow> getStringKeyPredicate() {
        ExpressionMetadata expressionEvaluator = this.createExpressionMetadata();
        return (key, row) -> {
            try {
                Kudf[] kudfs = expressionEvaluator.getUdfs();
                Object[] values = new Object[this.columnIndexes.length];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = this.columnIndexes[i] < 0 ? kudfs[i] : this.genericRowValueTypeEnforcer.enforceFieldType(this.columnIndexes[i], row.getColumns().get(this.columnIndexes[i]));
                }
                return (Boolean)this.ee.evaluate(values);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                log.error("Invalid format: " + key + " : " + row);
                return false;
            }
        };
    }

    private ExpressionMetadata createExpressionMetadata() {
        CodeGenRunner codeGenRunner = new CodeGenRunner(this.schema, this.functionRegistry);
        try {
            return codeGenRunner.buildCodeGenFromParseTree(this.filterExpression);
        }
        catch (Exception e) {
            throw new KsqlException("Failed to generate code for filterExpression:" + this.filterExpression + " schema:" + this.schema, (Throwable)e);
        }
    }

    private Predicate getWindowedKeyPredicate() {
        ExpressionMetadata expressionEvaluator = this.createExpressionMetadata();
        return (key, row) -> {
            try {
                Kudf[] kudfs = expressionEvaluator.getUdfs();
                Object[] values = new Object[this.columnIndexes.length];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = this.columnIndexes[i] < 0 ? kudfs[i] : this.genericRowValueTypeEnforcer.enforceFieldType(this.columnIndexes[i], row.getColumns().get(this.columnIndexes[i]));
                }
                return (Boolean)this.ee.evaluate(values);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                log.error("Invalid format: " + key + " : " + row);
                return false;
            }
        };
    }

    public Expression getFilterExpression() {
        return this.filterExpression;
    }

    public Schema getSchema() {
        return this.schema;
    }

    int[] getColumnIndexes() {
        int[] result = new int[this.columnIndexes.length];
        System.arraycopy(this.columnIndexes, 0, result, 0, this.columnIndexes.length);
        return result;
    }
}

