/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.structured;

import io.confluent.ksql.GenericRow;
import io.confluent.ksql.function.udf.Kudf;
import io.confluent.ksql.parser.tree.Expression;
import io.confluent.ksql.util.ExpressionMetadata;
import io.confluent.ksql.util.GenericRowValueTypeEnforcer;
import io.confluent.ksql.util.Pair;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.streams.kstream.ValueMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SelectValueMapper
implements ValueMapper<GenericRow, GenericRow> {
    private static Logger log = LoggerFactory.getLogger(SelectValueMapper.class);
    private final GenericRowValueTypeEnforcer typeEnforcer;
    private final List<Pair<String, Expression>> expressionPairList;
    private final List<ExpressionMetadata> expressionEvaluators;

    SelectValueMapper(GenericRowValueTypeEnforcer typeEnforcer, List<Pair<String, Expression>> expressionPairList, List<ExpressionMetadata> expressionEvaluators) {
        this.typeEnforcer = typeEnforcer;
        this.expressionPairList = expressionPairList;
        this.expressionEvaluators = expressionEvaluators;
    }

    public GenericRow apply(GenericRow row) {
        if (row == null) {
            return row;
        }
        ArrayList<Object> newColumns = new ArrayList<Object>();
        for (int i = 0; i < this.expressionPairList.size(); ++i) {
            try {
                int[] parameterIndexes = this.expressionEvaluators.get(i).getIndexes();
                Kudf[] kudfs = this.expressionEvaluators.get(i).getUdfs();
                Object[] parameterObjects = new Object[parameterIndexes.length];
                for (int j = 0; j < parameterIndexes.length; ++j) {
                    parameterObjects[j] = parameterIndexes[j] < 0 ? kudfs[j] : this.typeEnforcer.enforceFieldType(parameterIndexes[j], row.getColumns().get(parameterIndexes[j]));
                }
                newColumns.add(this.expressionEvaluators.get(i).getExpressionEvaluator().evaluate(parameterObjects));
                continue;
            }
            catch (Exception e) {
                log.error("Error calculating column with index " + i + " : " + (String)this.expressionPairList.get(i).getLeft(), (Throwable)e);
                newColumns.add(null);
            }
        }
        return new GenericRow(newColumns);
    }
}

