/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.structured;

import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.parser.tree.Expression;
import io.confluent.ksql.serde.WindowedSerde;
import io.confluent.ksql.structured.QueuedSchemaKStream;
import io.confluent.ksql.structured.SchemaKStream;
import io.confluent.ksql.structured.SelectValueMapper;
import io.confluent.ksql.structured.SqlPredicate;
import io.confluent.ksql.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Produced;
import org.apache.kafka.streams.kstream.ValueMapper;

public class SchemaKTable
extends SchemaKStream {
    private final KTable ktable;
    private final boolean isWindowed;

    public SchemaKTable(Schema schema, KTable ktable, Field keyField, List<SchemaKStream> sourceSchemaKStreams, boolean isWindowed, SchemaKStream.Type type, FunctionRegistry functionRegistry, SchemaRegistryClient schemaRegistryClient) {
        super(schema, null, keyField, sourceSchemaKStreams, type, functionRegistry, schemaRegistryClient);
        this.ktable = ktable;
        this.isWindowed = isWindowed;
    }

    @Override
    public SchemaKTable into(String kafkaTopicName, Serde<GenericRow> topicValueSerDe, Set<Integer> rowkeyIndexes) {
        if (this.isWindowed) {
            this.ktable.toStream().mapValues(row -> {
                if (row == null) {
                    return null;
                }
                ArrayList columns = new ArrayList();
                for (int i = 0; i < row.getColumns().size(); ++i) {
                    if (rowkeyIndexes.contains(i)) continue;
                    columns.add(row.getColumns().get(i));
                }
                return new GenericRow(columns);
            }).to(kafkaTopicName, Produced.with((Serde)new WindowedSerde(), topicValueSerDe));
        } else {
            this.ktable.toStream().mapValues(row -> {
                if (row == null) {
                    return null;
                }
                ArrayList columns = new ArrayList();
                for (int i = 0; i < row.getColumns().size(); ++i) {
                    if (rowkeyIndexes.contains(i)) continue;
                    columns.add(row.getColumns().get(i));
                }
                return new GenericRow(columns);
            }).to(kafkaTopicName, Produced.with((Serde)Serdes.String(), topicValueSerDe));
        }
        return this;
    }

    @Override
    public QueuedSchemaKStream toQueue(Optional<Integer> limit) {
        return new QueuedSchemaKStream(this, limit);
    }

    @Override
    public SchemaKTable filter(Expression filterExpression) {
        SqlPredicate predicate = new SqlPredicate(filterExpression, this.schema, this.isWindowed, this.functionRegistry);
        KTable filteredKTable = this.ktable.filter(predicate.getPredicate());
        return new SchemaKTable(this.schema, filteredKTable, this.keyField, Arrays.asList(this), this.isWindowed, SchemaKStream.Type.FILTER, this.functionRegistry, this.schemaRegistryClient);
    }

    @Override
    public SchemaKTable select(List<Pair<String, Expression>> expressionPairList) {
        Pair<Schema, SelectValueMapper> schemaAndMapper = this.createSelectValueMapperAndSchema(expressionPairList);
        KTable projectedKTable = this.ktable.mapValues((ValueMapper)schemaAndMapper.right);
        return new SchemaKTable((Schema)schemaAndMapper.left, projectedKTable, this.keyField, Collections.singletonList(this), this.isWindowed, SchemaKStream.Type.PROJECT, this.functionRegistry, this.schemaRegistryClient);
    }

    @Override
    public KStream getKstream() {
        return this.ktable.toStream();
    }

    public KTable getKtable() {
        return this.ktable;
    }

    public boolean isWindowed() {
        return this.isWindowed;
    }
}

