/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.structured;

import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.function.UdafAggregator;
import io.confluent.ksql.parser.tree.KsqlWindowExpression;
import io.confluent.ksql.parser.tree.WindowExpression;
import io.confluent.ksql.structured.SchemaKStream;
import io.confluent.ksql.structured.SchemaKTable;
import java.util.List;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.streams.kstream.Aggregator;
import org.apache.kafka.streams.kstream.Initializer;
import org.apache.kafka.streams.kstream.KGroupedStream;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Materialized;

public class SchemaKGroupedStream {
    private final Schema schema;
    private final KGroupedStream kgroupedStream;
    private final Field keyField;
    private final List<SchemaKStream> sourceSchemaKStreams;
    private final FunctionRegistry functionRegistry;
    private final SchemaRegistryClient schemaRegistryClient;

    SchemaKGroupedStream(Schema schema, KGroupedStream kgroupedStream, Field keyField, List<SchemaKStream> sourceSchemaKStreams, FunctionRegistry functionRegistry, SchemaRegistryClient schemaRegistryClient) {
        this.schema = schema;
        this.kgroupedStream = kgroupedStream;
        this.keyField = keyField;
        this.sourceSchemaKStreams = sourceSchemaKStreams;
        this.functionRegistry = functionRegistry;
        this.schemaRegistryClient = schemaRegistryClient;
    }

    public Field getKeyField() {
        return this.keyField;
    }

    public SchemaKTable aggregate(Initializer initializer, UdafAggregator aggregator, WindowExpression windowExpression, Serde<GenericRow> topicValueSerDe) {
        KTable aggKtable;
        if (windowExpression != null) {
            Materialized materialized = Materialized.with((Serde)Serdes.String(), topicValueSerDe);
            KsqlWindowExpression ksqlWindowExpression = windowExpression.getKsqlWindowExpression();
            aggKtable = ksqlWindowExpression.applyAggregate(this.kgroupedStream, initializer, aggregator, materialized);
        } else {
            aggKtable = this.kgroupedStream.aggregate(initializer, (Aggregator)aggregator, Materialized.with((Serde)Serdes.String(), topicValueSerDe));
        }
        return new SchemaKTable(this.schema, aggKtable, this.keyField, this.sourceSchemaKStreams, windowExpression != null, SchemaKStream.Type.AGGREGATE, this.functionRegistry, this.schemaRegistryClient);
    }
}

