/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.confluent.ksql.planner.plan.PlanNode;
import io.confluent.ksql.planner.plan.PlanNodeId;
import io.confluent.ksql.planner.plan.PlanVisitor;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import org.apache.kafka.connect.data.Schema;

@Immutable
public abstract class OutputNode
extends PlanNode {
    private final PlanNode source;
    private final Schema schema;
    private final Optional<Integer> limit;

    @JsonCreator
    protected OutputNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="schema") Schema schema, @JsonProperty(value="limit") Optional<Integer> limit) {
        super(id);
        Objects.requireNonNull(source, "source is null");
        Objects.requireNonNull(schema, "schema is null");
        this.source = source;
        this.schema = schema;
        this.limit = limit;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    public Optional<Integer> getLimit() {
        return this.limit;
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @Override
    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitOutput(this, context);
    }
}

