/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.datetime;

import io.confluent.ksql.function.KsqlFunctionException;
import io.confluent.ksql.function.udf.Kudf;
import java.sql.Timestamp;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public class TimestampToString
implements Kudf {
    private DateTimeFormatter threadSafeFormatter;

    @Override
    public Object evaluate(Object ... args) {
        if (args.length != 2) {
            throw new KsqlFunctionException("TimestampToString udf should have two input argument: date value and format.");
        }
        try {
            this.ensureInitialized(args);
            Timestamp timestamp = new Timestamp((Long)args[0]);
            return timestamp.toLocalDateTime().atZone(ZoneId.systemDefault()).format(this.threadSafeFormatter);
        }
        catch (Exception e) {
            throw new KsqlFunctionException("Exception running TimestampToString(" + args[0] + " , " + args[1] + ") : " + e.getMessage(), e);
        }
    }

    private void ensureInitialized(Object[] args) {
        if (this.threadSafeFormatter == null) {
            this.threadSafeFormatter = DateTimeFormatter.ofPattern(args[1].toString());
        }
    }
}

