/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udaf.topkdistinct;

import io.confluent.ksql.function.KsqlAggregateFunction;
import io.confluent.ksql.parser.tree.Expression;
import io.confluent.ksql.util.ArrayUtil;
import io.confluent.ksql.util.KsqlException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.streams.kstream.Merger;

public class TopkDistinctKudaf<T extends Comparable<? super T>>
extends KsqlAggregateFunction<T, T[]> {
    private final int tkVal;
    private final Class<T> ttClass;
    private final Comparator<T> comparator;
    private final Schema outputSchema;

    TopkDistinctKudaf(int argIndexInValue, int tkVal, Schema outputSchema, Class<T> ttClass) {
        super(argIndexInValue, () -> (Comparable[])Array.newInstance(ttClass, tkVal), SchemaBuilder.array((Schema)outputSchema).build(), Collections.singletonList(outputSchema));
        this.tkVal = tkVal;
        this.ttClass = ttClass;
        this.outputSchema = outputSchema;
        this.comparator = (v1, v2) -> {
            if (v1 == null && v2 == null) {
                return 0;
            }
            if (v1 == null) {
                return 1;
            }
            if (v2 == null) {
                return -1;
            }
            return Comparator.reverseOrder().compare((Comparable)v1, (Comparable)v2);
        };
    }

    @Override
    public T[] aggregate(T currentVal, T[] currentAggVal) {
        if (currentVal == null) {
            return currentAggVal;
        }
        if (ArrayUtil.containsValue(currentVal, currentAggVal)) {
            return currentAggVal;
        }
        int nullIndex = ArrayUtil.getNullIndex(currentAggVal);
        if (nullIndex != -1) {
            currentAggVal[nullIndex] = currentVal;
            Arrays.sort(currentAggVal, this.comparator);
            return currentAggVal;
        }
        T last = currentAggVal[currentAggVal.length - 1];
        if (currentVal.compareTo(last) <= 0) {
            return currentAggVal;
        }
        currentAggVal[currentAggVal.length - 1] = currentVal;
        Arrays.sort(currentAggVal, this.comparator);
        return currentAggVal;
    }

    @Override
    public Merger<String, T[]> getMerger() {
        return (aggKey, aggOne, aggTwo) -> {
            int nullIndex1 = ArrayUtil.getNullIndex(aggOne) == -1 ? this.tkVal : ArrayUtil.getNullIndex(aggOne);
            int nullIndex2 = ArrayUtil.getNullIndex(aggTwo) == -1 ? this.tkVal : ArrayUtil.getNullIndex(aggTwo);
            Comparable[] tempMergeTopkArray = (Comparable[])Array.newInstance(this.ttClass, nullIndex1 + nullIndex2);
            System.arraycopy(aggOne, 0, tempMergeTopkArray, 0, nullIndex1);
            int duplicateCount = 0;
            for (int i = nullIndex1; i < nullIndex1 + nullIndex2; ++i) {
                if (ArrayUtil.containsValue(aggTwo[i - nullIndex1], aggOne)) {
                    ++duplicateCount;
                    continue;
                }
                tempMergeTopkArray[i - duplicateCount] = aggTwo[i - nullIndex1];
            }
            tempMergeTopkArray = ArrayUtil.getNoNullArray(this.ttClass, tempMergeTopkArray);
            Arrays.sort(tempMergeTopkArray, this.comparator);
            if (tempMergeTopkArray.length < this.tkVal) {
                tempMergeTopkArray = ArrayUtil.padWithNull(this.ttClass, tempMergeTopkArray, this.tkVal);
                return tempMergeTopkArray;
            }
            return Arrays.copyOf(tempMergeTopkArray, this.tkVal);
        };
    }

    @Override
    public KsqlAggregateFunction<T, T[]> getInstance(Map<String, Integer> expressionNames, List<Expression> functionArguments) {
        if (functionArguments.size() != 2) {
            throw new KsqlException(String.format("Invalid parameter count. Need 2 args, got %d arg(s).", functionArguments.size()));
        }
        int udafIndex = expressionNames.get(functionArguments.get(0).toString());
        int tkValFromArg = Integer.parseInt(functionArguments.get(1).toString());
        return new TopkDistinctKudaf<T>(udafIndex, tkValFromArg, this.outputSchema, this.ttClass);
    }
}

