/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udaf.topk;

import io.confluent.ksql.function.AggregateFunctionFactory;
import io.confluent.ksql.function.KsqlAggregateFunction;
import io.confluent.ksql.function.udaf.topk.TopkKudaf;
import io.confluent.ksql.util.KsqlException;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;

public class TopKAggregateFunctionFactory
extends AggregateFunctionFactory {
    private final int topKSize;

    public TopKAggregateFunctionFactory() {
        this(0);
    }

    public TopKAggregateFunctionFactory(int topKSize) {
        super("TOPK", Collections.emptyList());
        this.topKSize = topKSize;
    }

    @Override
    public KsqlAggregateFunction getProperAggregateFunction(List<Schema> argumentType) {
        if (argumentType.isEmpty()) {
            throw new KsqlException("TOPK function should have two arguments.");
        }
        Schema argSchema = argumentType.get(0);
        switch (argSchema.type()) {
            case INT32: {
                return new TopkKudaf<Integer>(-1, this.topKSize, SchemaBuilder.array((Schema)Schema.INT32_SCHEMA).build(), Collections.singletonList(Schema.INT32_SCHEMA), Integer.class);
            }
            case INT64: {
                return new TopkKudaf<Long>(-1, this.topKSize, SchemaBuilder.array((Schema)Schema.INT64_SCHEMA).build(), Collections.singletonList(Schema.INT64_SCHEMA), Long.class);
            }
            case FLOAT64: {
                return new TopkKudaf<Double>(-1, this.topKSize, SchemaBuilder.array((Schema)Schema.FLOAT64_SCHEMA).build(), Collections.singletonList(Schema.FLOAT64_SCHEMA), Double.class);
            }
            case STRING: {
                return new TopkKudaf<String>(-1, this.topKSize, SchemaBuilder.array((Schema)Schema.STRING_SCHEMA).build(), Collections.singletonList(Schema.STRING_SCHEMA), String.class);
            }
        }
        throw new KsqlException("No TOPK aggregate function with " + argumentType.get(0) + " argument type exists!");
    }
}

