/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udaf.max;

import io.confluent.ksql.function.KsqlAggregateFunction;
import io.confluent.ksql.parser.tree.Expression;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.streams.kstream.Merger;

public class LongMaxKudaf
extends KsqlAggregateFunction<Long, Long> {
    LongMaxKudaf(int argIndexInValue) {
        super(argIndexInValue, () -> Long.MIN_VALUE, Schema.INT64_SCHEMA, Collections.singletonList(Schema.INT64_SCHEMA));
    }

    @Override
    public Long aggregate(Long currentVal, Long currentAggVal) {
        if (currentVal > currentAggVal) {
            return currentVal;
        }
        return currentAggVal;
    }

    @Override
    public Merger<String, Long> getMerger() {
        return (aggKey, aggOne, aggTwo) -> {
            if (aggOne > aggTwo) {
                return aggOne;
            }
            return aggTwo;
        };
    }

    @Override
    public KsqlAggregateFunction<Long, Long> getInstance(Map<String, Integer> expressionNames, List<Expression> functionArguments) {
        int udafIndex = expressionNames.get(functionArguments.get(0).toString());
        return new LongMaxKudaf(udafIndex);
    }
}

