/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udaf.max;

import io.confluent.ksql.function.KsqlAggregateFunction;
import io.confluent.ksql.parser.tree.Expression;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.streams.kstream.Merger;

public class DoubleMaxKudaf
extends KsqlAggregateFunction<Double, Double> {
    DoubleMaxKudaf(int argIndexInValue) {
        super(argIndexInValue, () -> Double.NEGATIVE_INFINITY, Schema.FLOAT64_SCHEMA, Collections.singletonList(Schema.FLOAT64_SCHEMA));
    }

    @Override
    public Double aggregate(Double currentVal, Double currentAggVal) {
        if (currentVal > currentAggVal) {
            return currentVal;
        }
        return currentAggVal;
    }

    @Override
    public Merger<String, Double> getMerger() {
        return (aggKey, aggOne, aggTwo) -> {
            if (aggOne > aggTwo) {
                return aggOne;
            }
            return aggTwo;
        };
    }

    @Override
    public KsqlAggregateFunction<Double, Double> getInstance(Map<String, Integer> expressionNames, List<Expression> functionArguments) {
        int udafIndex = expressionNames.get(functionArguments.get(0).toString());
        return new DoubleMaxKudaf(udafIndex);
    }
}

