/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udaf;

import io.confluent.ksql.GenericRow;
import io.confluent.ksql.function.KsqlAggregateFunction;
import io.confluent.ksql.function.UdafAggregator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.streams.kstream.Merger;

public class KudafAggregator
implements UdafAggregator {
    private Map<Integer, KsqlAggregateFunction> aggValToAggFunctionMap;
    private Map<Integer, Integer> aggValToValColumnMap;

    public KudafAggregator(Map<Integer, KsqlAggregateFunction> aggValToAggFunctionMap, Map<Integer, Integer> aggValToValColumnMap) {
        this.aggValToAggFunctionMap = aggValToAggFunctionMap;
        this.aggValToValColumnMap = aggValToValColumnMap;
    }

    public GenericRow apply(String s, GenericRow rowValue, GenericRow aggRowValue) {
        this.aggValToValColumnMap.forEach((key, value) -> aggRowValue.getColumns().set((int)key, rowValue.getColumns().get((int)value)));
        this.aggValToAggFunctionMap.forEach((key, value) -> aggRowValue.getColumns().set((int)key, value.aggregate(rowValue.getColumns().get(value.getArgIndexInValue()), aggRowValue.getColumns().get((int)key))));
        return aggRowValue;
    }

    public Merger<String, GenericRow> getMerger() {
        return (key, aggRowOne, aggRowTwo) -> {
            List columns = Stream.generate(String::new).limit(aggRowOne.getColumns().size()).collect(Collectors.toList());
            GenericRow mergedRow = new GenericRow(columns);
            this.aggValToValColumnMap.forEach((columnIndex, value) -> {
                if (aggRowOne.getColumns().get((int)value) == null) {
                    mergedRow.getColumns().set((int)columnIndex, aggRowTwo.getColumns().get((int)value));
                } else {
                    mergedRow.getColumns().set((int)columnIndex, aggRowOne.getColumns().get((int)value));
                }
            });
            this.aggValToAggFunctionMap.forEach((functionIndex, ksqlAggregateFunction) -> mergedRow.getColumns().set((int)functionIndex, ksqlAggregateFunction.getMerger().apply(key, aggRowOne.getColumns().get((int)functionIndex), aggRowTwo.getColumns().get((int)functionIndex))));
            return mergedRow;
        };
    }
}

