/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.ddl.commands;

import io.confluent.ksql.ddl.commands.DDLCommand;
import io.confluent.ksql.ddl.commands.DDLCommandResult;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.parser.tree.DropTopic;

public class DropTopicCommand
implements DDLCommand {
    private final String topicName;

    public DropTopicCommand(DropTopic dropTopic) {
        this.topicName = dropTopic.getTopicName().getSuffix();
    }

    DropTopicCommand(String topicName) {
        this.topicName = topicName;
    }

    @Override
    public DDLCommandResult run(MetaStore metaStore) {
        metaStore.deleteTopic(this.topicName);
        return new DDLCommandResult(true, "Topic " + this.topicName + " was dropped");
    }
}

