/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.ddl.commands;

import io.confluent.ksql.ddl.commands.AbstractCreateStreamCommand;
import io.confluent.ksql.ddl.commands.DDLCommandResult;
import io.confluent.ksql.metastore.KsqlTable;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.parser.tree.AbstractStreamCreateStatement;
import io.confluent.ksql.parser.tree.CreateTable;
import io.confluent.ksql.parser.tree.Expression;
import io.confluent.ksql.util.KafkaTopicClient;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.SchemaUtil;
import io.confluent.ksql.util.StringUtil;
import java.util.Map;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;

public class CreateTableCommand
extends AbstractCreateStreamCommand {
    private String stateStoreName;

    public CreateTableCommand(String sqlExpression, CreateTable createTable, Map<String, Object> overriddenProperties, KafkaTopicClient kafkaTopicClient, boolean enforceTopicExistence) {
        super(sqlExpression, (AbstractStreamCreateStatement)createTable, overriddenProperties, kafkaTopicClient, enforceTopicExistence);
        Map properties = createTable.getProperties();
        if (!properties.containsKey("KEY")) {
            throw new KsqlException("Cannot define a TABLE without providing the KEY column name in the WITH clause.");
        }
        this.stateStoreName = properties.containsKey("STATESTORE") ? StringUtil.cleanQuotes(((Expression)properties.get("STATESTORE")).toString()) : createTable.getName().toString() + "_statestore";
    }

    @Override
    public DDLCommandResult run(MetaStore metaStore) {
        if (this.registerTopicCommand != null) {
            this.registerTopicCommand.run(metaStore);
        }
        this.checkMetaData(metaStore, this.sourceName, this.topicName);
        KsqlTable ksqlTable = new KsqlTable(this.sqlExpression, this.sourceName, this.schema, this.keyColumnName.length() == 0 ? null : (Field)SchemaUtil.getFieldByName((Schema)this.schema, (String)this.keyColumnName).orElse(null), this.timestampColumnName.length() == 0 ? null : (Field)SchemaUtil.getFieldByName((Schema)this.schema, (String)this.timestampColumnName).orElse(null), metaStore.getTopic(this.topicName), this.stateStoreName, this.isWindowed);
        metaStore.putSource(ksqlTable.cloneWithTimeKeyColumns());
        return new DDLCommandResult(true, "Table created");
    }
}

