/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.ddl.commands;

import io.confluent.ksql.ddl.commands.AbstractCreateStreamCommand;
import io.confluent.ksql.ddl.commands.DDLCommandResult;
import io.confluent.ksql.metastore.KsqlStream;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.parser.tree.AbstractStreamCreateStatement;
import io.confluent.ksql.parser.tree.CreateStream;
import io.confluent.ksql.util.KafkaTopicClient;
import io.confluent.ksql.util.SchemaUtil;
import java.util.Map;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;

public class CreateStreamCommand
extends AbstractCreateStreamCommand {
    public CreateStreamCommand(String sqlExpression, CreateStream createStream, Map<String, Object> overriddenProperties, KafkaTopicClient kafkaTopicClient, boolean enforceTopicExistence) {
        super(sqlExpression, (AbstractStreamCreateStatement)createStream, overriddenProperties, kafkaTopicClient, enforceTopicExistence);
    }

    @Override
    public DDLCommandResult run(MetaStore metaStore) {
        if (this.registerTopicCommand != null) {
            this.registerTopicCommand.run(metaStore);
        }
        this.checkMetaData(metaStore, this.sourceName, this.topicName);
        KsqlStream ksqlStream = new KsqlStream(this.sqlExpression, this.sourceName, this.schema, this.keyColumnName.length() == 0 ? null : (Field)SchemaUtil.getFieldByName((Schema)this.schema, (String)this.keyColumnName).orElse(null), this.timestampColumnName.length() == 0 ? null : (Field)SchemaUtil.getFieldByName((Schema)this.schema, (String)this.timestampColumnName).orElse(null), metaStore.getTopic(this.topicName));
        metaStore.putSource(ksqlStream.cloneWithTimeKeyColumns());
        return new DDLCommandResult(true, "Stream created");
    }
}

