/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.ddl.commands;

import io.confluent.ksql.ddl.commands.DDLCommand;
import io.confluent.ksql.ddl.commands.RegisterTopicCommand;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.parser.tree.AbstractStreamCreateStatement;
import io.confluent.ksql.parser.tree.Expression;
import io.confluent.ksql.parser.tree.TableElement;
import io.confluent.ksql.util.KafkaTopicClient;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.KsqlPreconditions;
import io.confluent.ksql.util.SchemaUtil;
import io.confluent.ksql.util.StringUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;

abstract class AbstractCreateStreamCommand
implements DDLCommand {
    String sqlExpression;
    String sourceName;
    String topicName;
    Schema schema;
    String keyColumnName;
    String timestampColumnName;
    boolean isWindowed;
    RegisterTopicCommand registerTopicCommand;
    private KafkaTopicClient kafkaTopicClient;

    AbstractCreateStreamCommand(String sqlExpression, AbstractStreamCreateStatement statement, Map<String, Object> overriddenProperties, KafkaTopicClient kafkaTopicClient, boolean enforceTopicExistence) {
        this.sqlExpression = sqlExpression;
        this.topicName = this.sourceName = statement.getName().getSuffix();
        this.kafkaTopicClient = kafkaTopicClient;
        Map properties = statement.getProperties();
        this.validateWithClause(properties.keySet());
        if (properties.containsKey("REGISTERED_TOPIC") && !properties.containsKey("VALUE_FORMAT")) {
            this.topicName = StringUtil.cleanQuotes(((Expression)properties.get("REGISTERED_TOPIC")).toString().toUpperCase());
            this.checkTopicNameNotNull(properties);
        } else {
            this.registerTopicCommand = this.registerTopicFirst(properties, overriddenProperties, enforceTopicExistence);
        }
        this.schema = this.getStreamTableSchema(statement.getElements());
        this.keyColumnName = "";
        if (properties.containsKey("KEY")) {
            this.keyColumnName = ((Expression)properties.get("KEY")).toString().toUpperCase();
            this.keyColumnName = StringUtil.cleanQuotes(this.keyColumnName);
            if (!SchemaUtil.getFieldByName((Schema)this.schema, (String)this.keyColumnName).isPresent()) {
                throw new KsqlException(String.format("No column with the provided key column name in the WITH clause, %s, exists in the defined schema.", this.keyColumnName));
            }
        }
        this.timestampColumnName = "";
        if (properties.containsKey("TIMESTAMP")) {
            this.timestampColumnName = ((Expression)properties.get("TIMESTAMP")).toString().toUpperCase();
            this.timestampColumnName = StringUtil.cleanQuotes(this.timestampColumnName);
            if (!SchemaUtil.getFieldByName((Schema)this.schema, (String)this.timestampColumnName).isPresent()) {
                throw new KsqlException(String.format("No column with the provided timestamp column name in the WITH clause, %s, exists in the defined schema.", this.timestampColumnName));
            }
            if (((Field)SchemaUtil.getFieldByName((Schema)this.schema, (String)this.timestampColumnName).get()).schema().type() != Schema.Type.INT64) {
                throw new KsqlException("Timestamp column, " + this.timestampColumnName + ", should be LONG(INT64).");
            }
        }
        this.isWindowed = false;
        if (properties.containsKey("WINDOWED")) {
            String isWindowedProp = ((Expression)properties.get("WINDOWED")).toString().toUpperCase();
            try {
                this.isWindowed = Boolean.parseBoolean(isWindowedProp);
            }
            catch (Exception e) {
                throw new KsqlException("isWindowed property is not set correctly: " + isWindowedProp);
            }
        }
    }

    private void checkTopicNameNotNull(Map<String, Expression> properties) {
        KsqlPreconditions.checkNotNull((Object)properties.get("REGISTERED_TOPIC"), (Object)"Topic name should be set in WITH clause.");
    }

    private SchemaBuilder getStreamTableSchema(List<TableElement> tableElementList) {
        SchemaBuilder tableSchema = SchemaBuilder.struct();
        for (TableElement tableElement : tableElementList) {
            if (tableElement.getName().equalsIgnoreCase("ROWTIME") || tableElement.getName().equalsIgnoreCase("ROWKEY")) {
                throw new KsqlException("ROWTIME/ROWKEY are reserved token for implicit column. You cannot use them as a column name.");
            }
            tableSchema = tableSchema.field(tableElement.getName(), SchemaUtil.getTypeSchema((String)tableElement.getType()));
        }
        return tableSchema;
    }

    protected void checkMetaData(MetaStore metaStore, String sourceName, String topicName) {
        KsqlPreconditions.checkArgument((metaStore.getSource(sourceName) == null ? 1 : 0) != 0, (Object)String.format("Source %s already exists.", sourceName));
        KsqlPreconditions.checkNotNull((Object)metaStore.getTopic(topicName), (Object)String.format("The corresponding topic, %s, does not exist.", topicName));
    }

    protected RegisterTopicCommand registerTopicFirst(Map<String, Expression> properties, Map<String, Object> overriddenProperties, boolean enforceTopicExistence) {
        if (properties.size() == 0) {
            throw new KsqlException("Create Stream/Table statement needs WITH clause.");
        }
        if (!properties.containsKey("VALUE_FORMAT")) {
            throw new KsqlException("Topic format(VALUE_FORMAT) should be set in WITH clause.");
        }
        if (!properties.containsKey("KAFKA_TOPIC")) {
            throw new KsqlException("Corresponding kafka topic(KAFKA_TOPIC) should be set in WITH clause.");
        }
        String kafkaTopicName = StringUtil.cleanQuotes(properties.get("KAFKA_TOPIC").toString());
        if (enforceTopicExistence && !this.kafkaTopicClient.isTopicExists(kafkaTopicName)) {
            throw new KsqlException("Kafka topic does not exist: " + kafkaTopicName);
        }
        return new RegisterTopicCommand(this.topicName, false, properties);
    }

    private void validateWithClause(Set<String> withClauseVariables) {
        HashSet<String> validSet = new HashSet<String>();
        validSet.add("VALUE_FORMAT".toUpperCase());
        validSet.add("KAFKA_TOPIC".toUpperCase());
        validSet.add("KEY".toUpperCase());
        validSet.add("WINDOWED".toUpperCase());
        validSet.add("TIMESTAMP".toUpperCase());
        validSet.add("STATESTORE".toUpperCase());
        validSet.add("REGISTERED_TOPIC".toUpperCase());
        validSet.add("AVRO_SCHEMA_ID".toUpperCase());
        for (String withVariable : withClauseVariables) {
            if (validSet.contains(withVariable.toUpperCase())) continue;
            throw new KsqlException("Invalid config variable in the WITH clause: " + withVariable);
        }
    }
}

